/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.socketio;

import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.jfr.JFRSnapshot;
import org.graalvm.visualvm.jfr.model.JFRModel;
import org.graalvm.visualvm.jfr.view.JFRViewTab;
import org.graalvm.visualvm.jfr.views.socketio.JFRSnapshotSocketIOViewProvider;
import org.graalvm.visualvm.jfr.views.socketio.SocketIONode;
import org.graalvm.visualvm.jfr.views.socketio.SocketIOViewSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.RequestProcessor;

final class JFRSnapshotSocketIOView
extends JFRViewTab {
    private static final String IMAGE_PATH = "org/graalvm/visualvm/jfr/resources/socketio.png";
    private DataViewComponent dvc;
    private SocketIOViewSupport.MasterViewSupport masterView;
    private SocketIOViewSupport.DataViewSupport dataView;

    JFRSnapshotSocketIOView(JFRSnapshot jfrSnapshot) {
        super(jfrSnapshot, "Socket IO", new ImageIcon(ImageUtilities.loadImage((String)IMAGE_PATH, (boolean)true)).getImage(), 40);
    }

    @Override
    protected DataViewComponent createComponent() {
        JFRModel model = this.getModel();
        this.masterView = new SocketIOViewSupport.MasterViewSupport(model){

            @Override
            void firstShown() {
                this.changeAggregation(SocketIOViewSupport.Aggregation.ADDRESS_PORT, SocketIOViewSupport.Aggregation.NONE);
            }

            @Override
            void changeAggregation(SocketIOViewSupport.Aggregation primary, SocketIOViewSupport.Aggregation secondary) {
                JFRSnapshotSocketIOView.this.setAggregation(primary, secondary);
            }
        };
        boolean hasEvents = model != null && model.containsEvent(JFRSnapshotSocketIOViewProvider.EventChecker.class);
        this.dvc = new DataViewComponent(this.masterView.getMasterView(), new DataViewComponent.MasterViewConfiguration(!hasEvents));
        if (hasEvents) {
            this.dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration("Data", false), 1);
            this.dataView = new SocketIOViewSupport.DataViewSupport();
            this.dvc.addDetailsView(this.dataView.getDetailsView(), 1);
        }
        return this.dvc;
    }

    private void setAggregation(final SocketIOViewSupport.Aggregation primary, final SocketIOViewSupport.Aggregation secondary) {
        this.masterView.showProgress();
        this.dataView.setData(new SocketIONode.Root(), false);
        new RequestProcessor("JFR SocketIO Initializer").post(new Runnable(){

            @Override
            public void run() {
                final SocketIONode.Root root = new SocketIONode.Root(primary, secondary);
                JFRSnapshotSocketIOView.this.getModel().visitEvents(root);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JFRSnapshotSocketIOView.this.dataView.setData(root, !SocketIOViewSupport.Aggregation.NONE.equals((Object)secondary));
                        JFRSnapshotSocketIOView.this.masterView.hideProgress();
                    }
                });
            }
        });
    }
}

