/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.cli;

import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.modules.autoupdate.cli.Bundle;
import org.netbeans.spi.sendopts.Env;

final class CodeNameMatcher {
    private final Pattern[] patterns;

    private CodeNameMatcher(Pattern[] patternArray) {
        this.patterns = patternArray;
    }

    static CodeNameMatcher create(Env env, String[] stringArray) {
        Pattern[] patternArray = new Pattern[stringArray.length];
        for (int i = 0; i < patternArray.length; ++i) {
            try {
                patternArray[i] = Pattern.compile(stringArray[i]);
                continue;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                env.getErrorStream().println(Bundle.MSG_CantCompileRegex(stringArray[i]));
            }
        }
        return new CodeNameMatcher(patternArray);
    }

    boolean matches(String string) {
        for (Pattern pattern : this.patterns) {
            if (pattern == null || !pattern.matcher(string).matches()) continue;
            return true;
        }
        return false;
    }

    boolean isEmpty() {
        return this.patterns.length == 0;
    }

    public String toString() {
        return Arrays.toString(this.patterns);
    }
}

