/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zaproxy.zap.network.HttpEncoding;

public abstract class HttpBody {
    private static final Logger LOGGER = LogManager.getLogger(HttpBody.class);
    public static final String DEFAULT_CHARSET = StandardCharsets.ISO_8859_1.name();
    public static final int LIMIT_INITIAL_CAPACITY = 128000;
    private byte[] body;
    private int pos;
    private byte[] bodyDecoded;
    private String cachedString;
    private Charset charset;
    private boolean determineCharset = true;
    private boolean contentEncodingErrors;
    private List<HttpEncoding> encodings = List.of();

    public HttpBody() {
        this(0);
    }

    public HttpBody(int capacity) {
        this.body = new byte[Math.max(Math.min(capacity, 128000), 0)];
    }

    public HttpBody(byte[] contents) {
        if (contents != null) {
            this.setBody(contents);
        } else {
            this.body = new byte[0];
        }
    }

    public HttpBody(String contents) {
        if (contents != null) {
            this.setBody(contents);
        } else {
            this.body = new byte[0];
        }
    }

    public void setBody(byte[] contents) {
        if (contents == null) {
            return;
        }
        this.resetCachedValues();
        this.body = new byte[contents.length];
        System.arraycopy(contents, 0, this.body, 0, contents.length);
        this.pos = this.body.length;
    }

    public void setBody(String contents) {
        if (contents == null) {
            return;
        }
        this.cachedString = null;
        if (this.charset == null && this.isDetermineCharset()) {
            this.charset = this.determineCharset(contents);
        }
        this.bodyDecoded = contents.getBytes(this.getCharsetImpl());
        this.body = this.encode(this.bodyDecoded);
        this.pos = this.body.length;
    }

    protected byte[] encode(byte[] data) {
        if (this.encodings.isEmpty()) {
            return data;
        }
        byte[] value = data;
        try {
            byte[] decoded = value;
            for (HttpEncoding encoding : this.encodings) {
                decoded = encoding.encode(decoded);
            }
            this.contentEncodingErrors = false;
            return decoded;
        }
        catch (IOException e) {
            LOGGER.warn("An error occurred while encoding the body: {}", (Object)e.getMessage());
            this.contentEncodingErrors = true;
            return value;
        }
    }

    protected Charset determineCharset(String contents) {
        return null;
    }

    public void setDetermineCharset(boolean determine) {
        this.determineCharset = determine;
    }

    public boolean isDetermineCharset() {
        return this.determineCharset;
    }

    private Charset getCharsetImpl() {
        if (this.charset != null) {
            return this.charset;
        }
        return StandardCharsets.ISO_8859_1;
    }

    public void append(byte[] contents, int length) {
        if (contents == null || length <= 0) {
            return;
        }
        int len = Math.min(contents.length, length);
        if (this.pos + len > this.body.length) {
            byte[] newBody = new byte[this.pos + len];
            System.arraycopy(this.body, 0, newBody, 0, this.pos);
            this.body = newBody;
        }
        System.arraycopy(contents, 0, this.body, this.pos, len);
        this.pos += len;
        this.resetCachedValues();
    }

    private void resetCachedValues() {
        this.cachedString = null;
        this.bodyDecoded = null;
        this.contentEncodingErrors = false;
    }

    public void append(byte[] contents) {
        if (contents == null) {
            return;
        }
        this.append(contents, contents.length);
    }

    public void append(String contents) {
        if (contents == null) {
            return;
        }
        byte[] decoded = this.decode();
        byte[] contentsBytes = contents.getBytes(this.getCharsetImpl());
        byte[] data = new byte[decoded.length + contentsBytes.length];
        System.arraycopy(decoded, 0, data, 0, decoded.length);
        System.arraycopy(contentsBytes, 0, data, decoded.length, contentsBytes.length);
        this.bodyDecoded = data;
        this.setBody(this.encode(this.bodyDecoded));
    }

    public String toString() {
        if (this.cachedString != null) {
            return this.cachedString;
        }
        this.cachedString = this.createString(this.charset);
        return this.cachedString;
    }

    protected String createString(Charset charset) {
        return new String(this.decode(), charset != null ? charset : this.getCharsetImpl());
    }

    protected byte[] decode() {
        if (this.bodyDecoded != null) {
            return this.bodyDecoded;
        }
        this.bodyDecoded = this.decodeImpl();
        return this.bodyDecoded;
    }

    private byte[] decodeImpl() {
        byte[] value = this.pos != this.body.length ? Arrays.copyOf(this.body, this.pos) : this.body;
        try {
            byte[] decoded = value;
            for (HttpEncoding encoding : this.encodings) {
                decoded = encoding.decode(decoded);
            }
            this.contentEncodingErrors = false;
            return decoded;
        }
        catch (IOException e) {
            LOGGER.warn("An error occurred while decoding the body: {}", (Object)e.getMessage());
            this.contentEncodingErrors = true;
            return value;
        }
    }

    protected final int getPos() {
        return this.pos;
    }

    public byte[] getBytes() {
        return this.body;
    }

    public byte[] getContent() {
        if (this.encodings.isEmpty()) {
            return this.body;
        }
        return this.decode();
    }

    public boolean hasContentEncodingErrors() {
        return this.contentEncodingErrors;
    }

    public void setContent(byte[] content) {
        if (content == null) {
            return;
        }
        this.bodyDecoded = content;
        this.body = this.encode(this.bodyDecoded);
        this.pos = this.body.length;
        this.cachedString = null;
    }

    public int length() {
        return this.body.length;
    }

    public void setLength(int length) {
        if (length < 0 || this.body.length == length) {
            return;
        }
        int oldPos = this.pos;
        this.pos = Math.min(this.pos, length);
        byte[] newBody = new byte[length];
        System.arraycopy(this.body, 0, newBody, 0, this.pos);
        this.body = newBody;
        if (oldPos > this.pos) {
            this.resetCachedValues();
        }
    }

    public String getCharset() {
        if (this.charset != null) {
            return this.charset.name();
        }
        return DEFAULT_CHARSET;
    }

    public void setCharset(String charsetName) {
        if (StringUtils.isEmpty((CharSequence)charsetName)) {
            this.setCharsetImpl(null);
            return;
        }
        Charset newCharset = null;
        try {
            newCharset = Charset.forName(charsetName);
            if (newCharset != this.charset) {
                this.setCharsetImpl(newCharset);
            }
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            LOGGER.error("Failed to set charset: {}", (Object)charsetName, (Object)e);
        }
    }

    private void setCharsetImpl(Charset newCharset) {
        this.charset = newCharset;
        this.cachedString = null;
    }

    public void setContentEncodings(List<HttpEncoding> encodings) {
        Objects.requireNonNull(encodings);
        encodings.forEach(Objects::requireNonNull);
        this.encodings = List.copyOf(encodings);
        this.resetCachedValues();
    }

    public List<HttpEncoding> getContentEncodings() {
        return this.encodings;
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + Arrays.hashCode(this.body);
        result = 31 * result + Objects.hash(this.encodings);
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HttpBody otherBody = (HttpBody)object;
        if (!Arrays.equals(this.body, otherBody.body)) {
            return false;
        }
        return Objects.equals(this.encodings, otherBody.encodings);
    }
}

