import type { ClusterOrRawAttributeKeys, TCustomCluster, TCustomClusterPayload } from "zigbee-herdsman/dist/controller/tstype";
import type { TClusterPayload } from "zigbee-herdsman/dist/zspec/zcl/definition/clusters-types";
import type { ClusterDefinition } from "zigbee-herdsman/dist/zspec/zcl/definition/tstype";
import type * as exposes from "./exposes";
import type { Access, BatteryLinearVoltage, BatteryNonLinearVoltage, Configure, ElementOf, Fz, KeyValue, LevelConfigFeatures, ModernExtend, Range, Tz, Zh } from "./types";
export declare const TIME_LOOKUP: {
    MAX: number;
    "4_HOURS": number;
    "1_HOUR": number;
    "30_MINUTES": number;
    "5_MINUTES": number;
    "2_MINUTES": number;
    "1_MINUTE": number;
    "10_SECONDS": number;
    "5_SECONDS": number;
    "1_SECOND": number;
    MIN: number;
};
type ReportingConfigTime = number | keyof typeof TIME_LOOKUP;
type ReportingConfigAttribute<Cl extends string | number, Custom extends TCustomCluster | undefined = undefined> = ClusterOrRawAttributeKeys<Cl, Custom>[number] | {
    ID: number;
    type: number;
};
export type ReportingConfigWithoutAttribute = {
    min: ReportingConfigTime;
    max: ReportingConfigTime;
    change: number;
};
type ReportingConfig<Cl extends string | number, Custom extends TCustomCluster | undefined = undefined> = ReportingConfigWithoutAttribute & {
    attribute: ReportingConfigAttribute<Cl, Custom>;
};
export declare function setupAttributes<Cl extends string | number, Custom extends TCustomCluster | undefined = undefined>(entity: Zh.Device | Zh.Endpoint, coordinatorEndpoint: Zh.Endpoint, cluster: Cl, config: ReportingConfig<Cl, Custom>[], configureReporting?: boolean, read?: boolean): Promise<void>;
export declare function setupConfigureForReporting<Cl extends string | number, Custom extends TCustomCluster | undefined = undefined>(cluster: Cl, attribute: ReportingConfigAttribute<Cl, Custom>, args: {
    config?: false | ReportingConfigWithoutAttribute;
    access?: Access;
    endpointNames?: string[];
    singleEndpoint?: boolean;
}): Configure;
export declare function setupConfigureForBinding(cluster: string | number, clusterType: "input" | "output", endpointNames?: string[]): Configure;
export declare function setupConfigureForReading<Cl extends string | number, Custom extends TCustomCluster | undefined = undefined>(cluster: Cl, attributes: ClusterOrRawAttributeKeys<Cl, Custom>, endpointNames?: string[]): Configure;
export declare function forceDeviceType(args: {
    type: "EndDevice" | "Router";
}): ModernExtend;
export declare function forcePowerSource(args: {
    powerSource: "Mains (single phase)" | "Battery";
}): ModernExtend;
export interface LinkQualityArgs {
    reporting?: boolean;
    attribute?: ClusterOrRawAttributeKeys<"genBasic">[number];
    reportingConfig?: ReportingConfigWithoutAttribute;
}
export declare function linkQuality(args?: LinkQualityArgs): ModernExtend;
export interface BatteryArgs {
    voltageToPercentage?: BatteryNonLinearVoltage | BatteryLinearVoltage;
    dontDividePercentage?: boolean;
    percentage?: boolean;
    voltage?: boolean;
    lowStatus?: boolean;
    percentageReportingConfig?: ReportingConfigWithoutAttribute;
    percentageReporting?: boolean;
    voltageReportingConfig?: ReportingConfigWithoutAttribute;
    voltageReporting?: boolean;
    lowStatusReportingConfig?: ReportingConfigWithoutAttribute;
}
export declare function battery(args?: BatteryArgs): ModernExtend;
export declare function deviceTemperature(args?: Partial<NumericArgs<"genDeviceTempCfg">>): ModernExtend;
export declare function identify(args?: {
    isSleepy: boolean;
}): ModernExtend;
export interface OnOffArgs {
    powerOnBehavior?: boolean;
    ota?: ModernExtend["ota"];
    skipDuplicateTransaction?: boolean;
    endpointNames?: string[];
    configureReporting?: boolean;
    description?: string;
}
export declare function onOff(args?: OnOffArgs): ModernExtend;
export interface CommandsOnOffArgs {
    commands?: ("on" | "off" | "toggle")[];
    bind?: boolean;
    endpointNames?: string[];
}
export declare function commandsOnOff(args?: CommandsOnOffArgs): ModernExtend;
export declare function poll(args: {
    key: string;
    defaultIntervalSeconds: number;
    poll: (device: Zh.Device, options: KeyValue) => void;
    option?: exposes.Numeric;
    optionKey?: string;
}): ModernExtend;
export declare function writeTimeDaily(args: {
    endpointId: number;
}): ModernExtend;
export declare function iasArmCommandDefaultResponse(): ModernExtend;
export declare function iasGetPanelStatusResponse(): ModernExtend;
export declare function customTimeResponse(start: "1970_UTC" | "2000_LOCAL"): ModernExtend;
export declare function illuminance(args?: Partial<NumericArgs<"msIlluminanceMeasurement">>): ModernExtend;
export declare function temperature(args?: Partial<NumericArgs<"msTemperatureMeasurement">>): ModernExtend;
export declare function pressure(args?: Partial<NumericArgs<"msPressureMeasurement">>): ModernExtend;
export declare function flow(args?: Partial<NumericArgs<"msFlowMeasurement">>): ModernExtend;
export declare function humidity(args?: Partial<NumericArgs<"msRelativeHumidity">>): ModernExtend;
export declare function soilMoisture(args?: Partial<NumericArgs<"msSoilMoisture">>): ModernExtend;
export interface OccupancyArgs {
    pirConfig?: ("otu_delay" | "uto_delay" | "uto_threshold")[];
    ultrasonicConfig?: ("otu_delay" | "uto_delay" | "uto_threshold")[];
    contactConfig?: ("otu_delay" | "uto_delay" | "uto_threshold")[];
    reporting?: boolean;
    reportingConfig?: ReportingConfigWithoutAttribute;
    endpointNames?: string[];
}
export declare function occupancy(args?: OccupancyArgs): ModernExtend;
export declare function co2(args?: Partial<NumericArgs<"msCO2">>): ModernExtend;
export declare function pm25(args?: Partial<NumericArgs<"pm25Measurement">>): ModernExtend;
export interface LightArgs {
    effect?: boolean;
    powerOnBehavior?: boolean;
    colorTemp?: {
        startup?: boolean;
        range: Range;
    };
    color?: boolean | {
        modes?: ("xy" | "hs")[];
        applyRedFix?: boolean;
        enhancedHue?: boolean;
        moveToLevelWithOnOffDisable?: boolean;
    };
    turnsOffAtBrightness1?: boolean;
    configureReporting?: boolean;
    endpointNames?: string[];
    ota?: ModernExtend["ota"];
    levelConfig?: {
        features?: LevelConfigFeatures;
    };
    levelReportingConfig?: ReportingConfigWithoutAttribute;
    moveToLevelWithOnOffDisable?: boolean;
}
export declare function light(args?: LightArgs): ModernExtend;
export interface CommandsLevelCtrl {
    commands?: ("brightness_move_to_level" | "brightness_move_up" | "brightness_move_down" | "brightness_step_up" | "brightness_step_down" | "brightness_stop")[];
    bind?: boolean;
    endpointNames?: string[];
}
export declare function commandsLevelCtrl(args?: CommandsLevelCtrl): ModernExtend;
export type ColorCtrlCommand = "color_temperature_move_stop" | "color_temperature_move_up" | "color_temperature_move_down" | "color_temperature_step_up" | "color_temperature_step_down" | "enhanced_move_to_hue_and_saturation" | "move_to_hue_and_saturation" | "color_hue_step_up" | "color_hue_step_down" | "color_saturation_step_up" | "color_saturation_step_down" | "color_loop_set" | "color_temperature_move" | "color_move" | "hue_move" | "hue_stop" | "move_to_saturation" | "move_to_hue";
export interface CommandsColorCtrl {
    commands?: ColorCtrlCommand[];
    bind?: boolean;
    endpointNames?: string[];
}
export declare function commandsColorCtrl(args?: CommandsColorCtrl): ModernExtend;
export declare function lightingBallast(): ModernExtend;
export interface LockArgs {
    pinCodeCount: number;
    endpointNames?: string[];
    readPinCodeOnProgrammingEvent?: boolean;
}
export declare function lock(args: LockArgs): ModernExtend;
export interface WindowCoveringArgs {
    controls: ("lift" | "tilt")[];
    coverInverted?: boolean;
    stateSource?: "lift" | "tilt";
    configureReporting?: boolean;
    coverMode?: boolean;
    endpointNames?: string[];
}
export declare function windowCovering(args: WindowCoveringArgs): ModernExtend;
export interface CommandsWindowCoveringArgs {
    commands?: ("open" | "close" | "stop")[];
    bind?: boolean;
    endpointNames?: string[];
}
export declare function commandsWindowCovering(args?: CommandsWindowCoveringArgs): ModernExtend;
export type IasZoneType = "occupancy" | "contact" | "smoke" | "water_leak" | "rain" | "carbon_monoxide" | "sos" | "vibration" | "alarm" | "gas" | "generic";
export type IasZoneAttribute = "alarm_1" | "alarm_2" | "tamper" | "battery_low" | "supervision_reports" | "restore_reports" | "ac_status" | "test" | "trouble" | "battery_defect";
export type ManufacturerZoneAttribute = {
    bit: 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9 | 10 | 11 | 12 | 13 | 14 | 15;
    name: string;
    valueOn: string | boolean;
    valueOff: string | boolean;
    description: string;
    entityCategory?: "config" | "diagnostic";
};
export interface IasArgs {
    zoneType: IasZoneType;
    zoneAttributes: IasZoneAttribute[];
    alarmTimeout?: boolean;
    keepAliveTimeout?: number;
    zoneStatusReporting?: boolean;
    description?: string;
    manufacturerZoneAttributes?: ManufacturerZoneAttribute[];
}
export declare function iasZoneAlarm(args: IasArgs): ModernExtend;
export interface IasWarningArgs {
    reversePayload?: boolean;
}
export declare function iasWarning(args?: IasWarningArgs): ModernExtend;
type MultiplierDivisor = {
    multiplier?: number;
    divisor?: number;
};
type MeterType = "electricity" | "gas";
interface MeterArgs {
    type?: MeterType;
    cluster?: "both" | "metering" | "electrical";
    power?: false | (MultiplierDivisor & Partial<ReportingConfigWithoutAttribute> & {
        cluster?: "metering" | "electrical";
    });
    energy?: false | (MultiplierDivisor & Partial<ReportingConfigWithoutAttribute>);
    status?: boolean;
    extendedStatus?: boolean;
    configureReporting?: boolean;
    endpointNames?: string[];
    fzMetering?: Fz.Converter<"seMetering", any, any>;
    electricalMeasurementType?: "both" | "ac" | "dc";
    voltage?: false | (MultiplierDivisor & Partial<ReportingConfigWithoutAttribute>);
    current?: false | (MultiplierDivisor & Partial<ReportingConfigWithoutAttribute>);
    threePhase?: boolean;
    producedEnergy?: false | true | (MultiplierDivisor & Partial<ReportingConfigWithoutAttribute>);
    acFrequency?: false | true | (MultiplierDivisor & Partial<ReportingConfigWithoutAttribute>);
    powerFactor?: boolean;
    fzElectricalMeasurement?: Fz.Converter<"haElectricalMeasurement", any, any>;
}
export interface ElectricityMeterArgs extends MeterArgs {
    type?: "electricity";
}
export declare function electricityMeter(args?: ElectricityMeterArgs): ModernExtend;
export interface GasMeterArgs extends MeterArgs {
    type?: "gas";
}
export declare function gasMeter(args?: GasMeterArgs): ModernExtend;
/**
 * Version of the GP spec: 1.1.1
 */
export declare const GPDF_COMMANDS: Record<number, string>;
export declare function genericGreenPower(): ModernExtend;
export interface CommandsScenesArgs {
    commands?: string[];
    bind?: boolean;
    endpointNames?: string[];
}
export declare function commandsScenes(args?: CommandsScenesArgs): ModernExtend;
export interface ClusterWithAttribute<Cl extends string | number, Custom extends TCustomCluster | undefined = undefined, Co extends string | undefined = undefined> {
    cluster: Cl;
    attribute: Co extends undefined ? // biome-ignore lint/style/useNamingConvention: API
    (ClusterOrRawAttributeKeys<Cl, Custom> & string)[number] | {
        ID: number;
        type: number;
    } : Custom extends TCustomCluster ? TCustomClusterPayload<Custom, Co> extends never ? keyof TClusterPayload<Cl, Co> : keyof TClusterPayload<Cl, Co> | keyof TCustomClusterPayload<Custom, Co> : keyof TClusterPayload<Cl, Co>;
}
export interface EnumLookupArgs<Cl extends string | number, Custom extends TCustomCluster | undefined = undefined> extends ClusterWithAttribute<Cl, Custom> {
    name: string;
    lookup: KeyValue;
    description: string;
    zigbeeCommandOptions?: {
        manufacturerCode?: number;
        disableDefaultResponse?: boolean;
    };
    access?: "STATE" | "STATE_GET" | "STATE_SET" | "SET" | "ALL";
    endpointName?: string;
    reporting?: ReportingConfigWithoutAttribute;
    entityCategory?: "config" | "diagnostic";
    label?: string;
}
export declare function enumLookup<Cl extends string | number, Custom extends TCustomCluster | undefined = undefined>(args: EnumLookupArgs<Cl, Custom>): ModernExtend;
export type ScaleFunction = (value: number, type: "from" | "to") => number;
export interface NumericArgs<Cl extends string | number, Custom extends TCustomCluster | undefined = undefined> extends ClusterWithAttribute<Cl, Custom> {
    name: string;
    description: string;
    zigbeeCommandOptions?: {
        manufacturerCode?: number;
        disableDefaultResponse?: boolean;
    };
    access?: "STATE" | "STATE_GET" | "STATE_SET" | "SET" | "ALL";
    unit?: string;
    endpointNames?: string[];
    reporting?: false | ReportingConfigWithoutAttribute;
    valueMin?: number;
    valueMax?: number;
    valueStep?: number;
    scale?: number | ScaleFunction;
    label?: string;
    entityCategory?: "config" | "diagnostic";
    precision?: number;
}
export declare function numeric<Cl extends string | number, Custom extends TCustomCluster | undefined = undefined>(args: NumericArgs<Cl, Custom>): ModernExtend;
export interface BinaryArgs<Cl extends string | number, Custom extends TCustomCluster | undefined = undefined> extends ClusterWithAttribute<Cl, Custom> {
    name: string;
    valueOn: [string | boolean, unknown];
    valueOff: [string | boolean, unknown];
    description: string;
    zigbeeCommandOptions?: {
        manufacturerCode: number;
    };
    endpointName?: string;
    reporting?: false | ReportingConfig<Cl, Custom>;
    access?: "STATE" | "STATE_GET" | "STATE_SET" | "SET" | "ALL";
    label?: string;
    entityCategory?: "config" | "diagnostic";
}
export declare function binary<Cl extends string | number, Custom extends TCustomCluster | undefined = undefined>(args: BinaryArgs<Cl, Custom>): ModernExtend;
export interface TextArgs<Cl extends string | number, Custom extends TCustomCluster | undefined = undefined> extends ClusterWithAttribute<Cl, Custom> {
    name: string;
    description: string;
    zigbeeCommandOptions?: {
        manufacturerCode: number;
    };
    endpointName?: string;
    reporting?: ReportingConfig<Cl, Custom>;
    access?: "STATE" | "STATE_GET" | "STATE_SET" | "SET" | "ALL";
    entityCategory?: "config" | "diagnostic";
    validate?(value: unknown): void;
}
export declare function text<Cl extends string | number, Custom extends TCustomCluster | undefined = undefined>(args: TextArgs<Cl, Custom>): ModernExtend;
export interface ActionEnumLookupArgs<Cl extends string | number, Custom extends TCustomCluster | undefined = undefined, Cos extends Fz.ConverterTypeCmd<Cl, Custom>[] | undefined = undefined> extends ClusterWithAttribute<Cl, Custom, ElementOf<Cos> extends infer Single ? (Single extends `command${infer Co}` ? Uncapitalize<Co> : undefined) : undefined> {
    actionLookup: KeyValue;
    endpointNames?: string[];
    buttonLookup?: KeyValue;
    extraActions?: string[];
    commands?: Cos;
    parse?: (msg: Fz.Message<Cl, Custom, Cos extends undefined ? ["attributeReport", "readResponse"] : Cos>, attributeKey: ClusterWithAttribute<Cl, Custom, ElementOf<Cos> extends infer Single ? (Single extends `command${infer Co}` ? Uncapitalize<Co> : undefined) : undefined>["attribute"] | number) => unknown;
}
export declare function actionEnumLookup<Cl extends string | number, Custom extends TCustomCluster | undefined = undefined, Cos extends Fz.ConverterTypeCmd<Cl, Custom>[] | undefined = undefined>(args: ActionEnumLookupArgs<Cl, Custom, Cos>): ModernExtend;
export interface QuirkAddEndpointClusterArgs {
    endpointID: number;
    inputClusters?: string[] | number[];
    outputClusters?: string[] | number[];
}
export declare function quirkAddEndpointCluster(args: QuirkAddEndpointClusterArgs): ModernExtend;
export declare function quirkCheckinInterval(timeout: number | keyof typeof TIME_LOOKUP): ModernExtend;
export declare function reconfigureReportingsOnDeviceAnnounce(): ModernExtend;
export declare function skipDefaultResponse(): ModernExtend;
export declare function deviceEndpoints(args: {
    endpoints: {
        [n: string]: number;
    };
    multiEndpointSkip?: string[];
}): ModernExtend;
export declare function deviceAddCustomCluster(clusterName: string, clusterDefinition: ClusterDefinition): ModernExtend;
export declare function ignoreClusterReport(args: {
    cluster: string | number;
}): ModernExtend;
export declare function bindCluster(args: {
    cluster: string | number;
    clusterType: "input" | "output";
    endpointNames?: string[];
}): ModernExtend;
interface MinMaxStep {
    min: number;
    max: number;
    step: number;
}
declare const SETPOINT_LOOKUP: {
    readonly occupiedHeatingSetpoint: {
        readonly property: "occupied_heating_setpoint";
        readonly tzConverter: Tz.Converter;
    };
    readonly unoccupiedHeatingSetpoint: {
        readonly property: "unoccupied_heating_setpoint";
        readonly tzConverter: Tz.Converter;
    };
    readonly occupiedCoolingSetpoint: {
        readonly property: "occupied_cooling_setpoint";
        readonly tzConverter: Tz.Converter;
    };
    readonly unoccupiedCoolingSetpoint: {
        readonly property: "unoccupied_cooling_setpoint";
        readonly tzConverter: Tz.Converter;
    };
};
declare const SETPOINT_LIMIT_LOOKUP: {
    readonly maxHeatSetpointLimit: {
        readonly tzConverter: Tz.Converter;
        readonly expose: (min: number, max: number, step: number) => exposes.Numeric;
    };
    readonly minHeatSetpointLimit: {
        readonly tzConverter: Tz.Converter;
        readonly expose: (min: number, max: number, step: number) => exposes.Numeric;
    };
    readonly maxCoolSetpointLimit: {
        readonly tzConverter: Tz.Converter;
        readonly expose: (min: number, max: number, step: number) => exposes.Numeric;
    };
    readonly minCoolSetpointLimit: {
        readonly tzConverter: Tz.Converter;
        readonly expose: (min: number, max: number, step: number) => exposes.Numeric;
    };
};
export interface ThermostatArgs {
    localTemperatureCalibration?: true | MinMaxStep;
    setpoints?: Partial<Record<keyof typeof SETPOINT_LOOKUP, MinMaxStep>>;
    setpointsLimit?: Partial<Record<keyof typeof SETPOINT_LIMIT_LOOKUP, MinMaxStep>>;
    systemMode?: Array<"off" | "heat" | "cool" | "auto" | "dry" | "fan_only" | "sleep" | "emergency_heating">;
    runningState?: Array<"idle" | "heat" | "cool" | "fan_only">;
    runningMode?: Array<"off" | "cool" | "heat">;
    fanMode?: Array<"off" | "low" | "medium" | "high" | "on" | "auto" | "smart">;
    piHeatingDemand?: true;
    temperatureSetpointHold?: true;
    temperatureSetpointHoldDuration?: true;
}
export declare function thermostat(args?: ThermostatArgs): ModernExtend;
export {};
//# sourceMappingURL=modernExtend.d.ts.map