set(PARSEC_VERSION 3.0.2209)


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was PaRSECConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set_and_check(PARSEC_DIR "${PACKAGE_PREFIX_DIR}")
set_and_check(PARSEC_INCLUDE_DIRS "${PACKAGE_PREFIX_DIR}/include")
set_and_check(PARSEC_CMAKE_DIRS "${PACKAGE_PREFIX_DIR}/share/cmake/parsec")
set_and_check(PARSEC_LIBRARY_DIRS "${PACKAGE_PREFIX_DIR}/lib")
set_and_check(PARSEC_BINARY_DIRS "${PACKAGE_PREFIX_DIR}/bin")
set(PARSEC_LIBEXEC_DIRS "${PACKAGE_PREFIX_DIR}/libexec") # This is optional, may not exist in the installdir

# Pull the dependencies
list(APPEND CMAKE_PREFIX_PATH "${PARSEC_CMAKE_DIRS}")
list(APPEND CMAKE_MODULE_PATH "${PARSEC_CMAKE_DIRS}")

find_package(Threads)

if(TRUE)
  # If HWLOC is found on the system directories the HWLOC_DIR is set to ""
  if("")
    set_and_check(HWLOC_DIR "")
  endif("")
  find_package(HWLOC REQUIRED)
endif(TRUE)

if(FALSE)
  # Nothing exportable here, if this test succeed then PaRSEC supports OTF2 output.
endif(FALSE)

if(FALSE)
  set_and_check(PAPI_INCLUDE_DIR "PAPI_INCLUDE_DIR-NOTFOUND")
  set_and_check(PAPI_LIBRARY "PAPI_LIBRARY-NOTFOUND")
  find_package(PAPI REQUIRED)
endif(FALSE)

if(OFF)
  # Otherwise try to find MPI in the normal way
  find_package(MPI REQUIRED)
endif(OFF)

if()
  find_package(CUDA REQUIRED)
  SET(PARSEC_HAVE_CUDA TRUE)
endif()

if(OFF)
  # Nothing exportable here, if this test succeed then PaRSEC supports tracing
endif(OFF)

# Pull the PaRSEC::<targets>
if(NOT TARGET PaRSEC::parsec)
  include(${CMAKE_CURRENT_LIST_DIR}/PaRSECTargets.cmake)
endif(NOT TARGET PaRSEC::parsec)

# Populate the variables

set(PARSEC_PTGFLAGS "$ENV{PTGFLAGS}" CACHE STRING "Flags to pass to the parsec-ptgpp executable")
set(PARSEC_PTGPP_EXECUTABLE ${PARSEC_BINARY_DIRS}/parsec-ptgpp CACHE STRING "Point to the parsec-ptgpp executable")
set(PARSEC_LIBRARIES PaRSEC::parsec CACHE STRING "List of libraries suitable for use in target_link_libraries") # for compatibility with older (non-target based) clients
