
#ifndef PLASMA_ACTIVITIES_EXPORT_H
#define PLASMA_ACTIVITIES_EXPORT_H

#ifdef PLASMA_ACTIVITIES_STATIC_DEFINE
#  define PLASMA_ACTIVITIES_EXPORT
#  define PLASMA_ACTIVITIES_NO_EXPORT
#else
#  ifndef PLASMA_ACTIVITIES_EXPORT
#    ifdef PlasmaActivities_EXPORTS
        /* We are building this library */
#      define PLASMA_ACTIVITIES_EXPORT __declspec(dllexport)
#    else
        /* We are using this library */
#      define PLASMA_ACTIVITIES_EXPORT __declspec(dllimport)
#    endif
#  endif

#  ifndef PLASMA_ACTIVITIES_NO_EXPORT
#    define PLASMA_ACTIVITIES_NO_EXPORT 
#  endif
#endif

#ifndef PLASMA_ACTIVITIES_DECL_DEPRECATED
#  define PLASMA_ACTIVITIES_DECL_DEPRECATED __declspec(deprecated)
#endif

#ifndef PLASMA_ACTIVITIES_DECL_DEPRECATED_EXPORT
#  define PLASMA_ACTIVITIES_DECL_DEPRECATED_EXPORT PLASMA_ACTIVITIES_EXPORT PLASMA_ACTIVITIES_DECL_DEPRECATED
#endif

#ifndef PLASMA_ACTIVITIES_DECL_DEPRECATED_NO_EXPORT
#  define PLASMA_ACTIVITIES_DECL_DEPRECATED_NO_EXPORT PLASMA_ACTIVITIES_NO_EXPORT PLASMA_ACTIVITIES_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef PLASMA_ACTIVITIES_NO_DEPRECATED
#    define PLASMA_ACTIVITIES_NO_DEPRECATED
#  endif
#endif
#include <plasma_activities_version.h>

#define PLASMA_ACTIVITIES_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#if defined(PLASMA_ACTIVITIES_NO_DEPRECATED)
#  undef PLASMA_ACTIVITIES_DEPRECATED
#  define PLASMA_ACTIVITIES_DEPRECATED_EXPORT PLASMA_ACTIVITIES_EXPORT
#  define PLASMA_ACTIVITIES_DEPRECATED_NO_EXPORT PLASMA_ACTIVITIES_NO_EXPORT
#elif defined(PLASMA_ACTIVITIES_NO_DEPRECATED_WARNINGS)
#  define PLASMA_ACTIVITIES_DEPRECATED
#  define PLASMA_ACTIVITIES_DEPRECATED_EXPORT PLASMA_ACTIVITIES_EXPORT
#  define PLASMA_ACTIVITIES_DEPRECATED_NO_EXPORT PLASMA_ACTIVITIES_NO_EXPORT
#else
#  define PLASMA_ACTIVITIES_DEPRECATED PLASMA_ACTIVITIES_DECL_DEPRECATED
#  define PLASMA_ACTIVITIES_DEPRECATED_EXPORT PLASMA_ACTIVITIES_DECL_DEPRECATED_EXPORT
#  define PLASMA_ACTIVITIES_DEPRECATED_NO_EXPORT PLASMA_ACTIVITIES_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define PLASMA_ACTIVITIES_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define PLASMA_ACTIVITIES_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef PLASMA_ACTIVITIES_NO_DEPRECATED
#  define PLASMA_ACTIVITIES_DISABLE_DEPRECATED_BEFORE_AND_AT PLASMA_ACTIVITIES_VERSION
#endif
#ifdef PLASMA_ACTIVITIES_NO_DEPRECATED_WARNINGS
#  define PLASMA_ACTIVITIES_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef PLASMA_ACTIVITIES_DEPRECATED_WARNINGS_SINCE
#  ifdef PLASMA_ACTIVITIES_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define PLASMA_ACTIVITIES_DEPRECATED_WARNINGS_SINCE PLASMA_ACTIVITIES_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define PLASMA_ACTIVITIES_DEPRECATED_WARNINGS_SINCE PLASMA_ACTIVITIES_VERSION
#  endif
#endif

#ifndef PLASMA_ACTIVITIES_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define PLASMA_ACTIVITIES_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef PLASMA_ACTIVITIES_DEPRECATED
#  define PLASMA_ACTIVITIES_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > PLASMA_ACTIVITIES_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define PLASMA_ACTIVITIES_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* PLASMA_ACTIVITIES_EXPORT_H */
