#ifndef _CEGOATTRDESC_H_INCLUDED_
#define _CEGOATTRDESC_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoAttrDesc.h
// --------------
// Cego table attribute description class definition
//      
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2019 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoAttrDesc
// 
// Description: Table attribute container class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>
#include <lfcxml/Element.h>

// CEGO INCLUDES
#include "CegoContentObject.h"
#include "CegoField.h"

class CegoDatabaseFormater;

class CegoAttrDesc {

public:

    CegoAttrDesc();
    CegoAttrDesc(Element *pADE);
    CegoAttrDesc(const Chain& attrName);
    CegoAttrDesc(const Chain& tableName, const Chain& attrName, bool isValid = false);
    ~CegoAttrDesc();

    void setValid(bool isValid);
    bool isValid() const;

    void setAttrName(const Chain& attrName);
    const Chain& getAttrName() const;

    void setTableName(const Chain& tableName);
    const Chain& getTableName() const;

    CegoAttrDesc* clone() const;

    CegoAttrDesc& operator = ( const CegoAttrDesc& ad);
    bool operator == ( const CegoAttrDesc& ad) const;
    bool operator != ( const CegoAttrDesc& ad) const;

    Chain getId() const;
    Chain toChain() const;
    Chain dbFormat(CegoDatabaseFormater* pForm) const;
	
    Element* toElement() const;
    void fromElement(Element *pAttrDescElement);

    void encode(char *buf);
    void decode(char *buf);
    int getEncodingLength() const;

    int evalReferences(CegoContentObject *pCO, const ListT<CegoField>& fl);
    
    friend ostream& operator << (ostream& s, const CegoAttrDesc& a);
    
private:

    int evalTableReferences(CegoContentObject *pCO, const ListT<CegoField>& fl);
    
    bool _isValid;
    Chain _tableName;
    Chain _attrName;  
};

#endif
