#ifndef _CEGOORDERNODE_H_INCLUDED_
#define _CEGOORDERNODE_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoOrderNode.h
// ---------------
// Cego order node class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2019 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoOrderNode
// 
// Description: Tuple ordering handle
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/ListT.h>
// CEGO INCLUDE
#include "CegoField.h"

class CegoOrderNode {

public:
    
    enum Ordering { ASC, DESC };
    
    CegoOrderNode();
    CegoOrderNode(ListT<CegoFieldValue>& key, ListT<CegoFieldValue>& tuple, ListT<Ordering>* pOrdering);
    ~CegoOrderNode();
    
    ListT<CegoFieldValue>& getKey();
    ListT<CegoFieldValue>& getTuple();

    CegoOrderNode& operator = ( const CegoOrderNode& n);
    bool operator == ( const CegoOrderNode& n);
    bool operator > ( const CegoOrderNode& n);
    bool operator < ( const CegoOrderNode& n);

 private:
    
    ListT<Ordering>* _pOrdering;
    ListT<CegoFieldValue> _key;
    ListT<CegoFieldValue> _tuple;
    
};

#endif
