/*
 * Copyright The OpenTelemetry Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
class HttpExporterTransport {
    _parameters;
    _utils = null;
    constructor(_parameters) {
        this._parameters = _parameters;
    }
    async send(data, timeoutMillis) {
        const { agent, send } = this._loadUtils();
        return new Promise(resolve => {
            send(this._parameters, agent, data, result => {
                resolve(result);
            }, timeoutMillis);
        });
    }
    shutdown() {
        // intentionally left empty, nothing to do.
    }
    _loadUtils() {
        let utils = this._utils;
        if (utils === null) {
            // Lazy require to ensure that http/https is not required before instrumentations can wrap it.
            const { sendWithHttp, createHttpAgent,
            // eslint-disable-next-line @typescript-eslint/no-require-imports
             } = require('./http-transport-utils');
            utils = this._utils = {
                agent: createHttpAgent(this._parameters.url, this._parameters.agentOptions),
                send: sendWithHttp,
            };
        }
        return utils;
    }
}
export function createHttpExporterTransport(parameters) {
    return new HttpExporterTransport(parameters);
}
//# sourceMappingURL=http-exporter-transport.js.map