/**************************************************************************/
/*  sub_viewport_container.hpp                                            */
/**************************************************************************/
/*                         This file is part of:                          */
/*                             GODOT ENGINE                               */
/*                        https://godotengine.org                         */
/**************************************************************************/
/* Copyright (c) 2014-present Godot Engine contributors (see AUTHORS.md). */
/* Copyright (c) 2007-2014 Juan Linietsky, Ariel Manzur.                  */
/*                                                                        */
/* Permission is hereby granted, free of charge, to any person obtaining  */
/* a copy of this software and associated documentation files (the        */
/* "Software"), to deal in the Software without restriction, including    */
/* without limitation the rights to use, copy, modify, merge, publish,    */
/* distribute, sublicense, and/or sell copies of the Software, and to     */
/* permit persons to whom the Software is furnished to do so, subject to  */
/* the following conditions:                                              */
/*                                                                        */
/* The above copyright notice and this permission notice shall be         */
/* included in all copies or substantial portions of the Software.        */
/*                                                                        */
/* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,        */
/* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF     */
/* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. */
/* IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY   */
/* CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,   */
/* TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE      */
/* SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.                 */
/**************************************************************************/

// THIS FILE IS GENERATED. EDITS WILL BE LOST.

#ifndef GODOT_CPP_SUB_VIEWPORT_CONTAINER_HPP
#define GODOT_CPP_SUB_VIEWPORT_CONTAINER_HPP

#include <godot_cpp/classes/container.hpp>
#include <godot_cpp/classes/ref.hpp>

#include <godot_cpp/core/class_db.hpp>

#include <type_traits>

namespace godot {

class InputEvent;

class SubViewportContainer : public Container {
	GDEXTENSION_CLASS(SubViewportContainer, Container)

public:
	void set_stretch(bool p_enable);
	bool is_stretch_enabled() const;
	void set_stretch_shrink(int32_t p_amount);
	int32_t get_stretch_shrink() const;
	void set_mouse_target(bool p_amount);
	bool is_mouse_target_enabled();
	virtual bool _propagate_input_event(const Ref<InputEvent> &p_event) const;

protected:
	template <typename T, typename B>
	static void register_virtuals() {
		Container::register_virtuals<T, B>();
		if constexpr (!std::is_same_v<decltype(&B::_propagate_input_event), decltype(&T::_propagate_input_event)>) {
			BIND_VIRTUAL_METHOD(T, _propagate_input_event, 3738334489);
		}
	}

public:
};

} // namespace godot

#endif // ! GODOT_CPP_SUB_VIEWPORT_CONTAINER_HPP
