
#ifndef KICONWIDGETS_EXPORT_H
#define KICONWIDGETS_EXPORT_H

#ifdef KICONWIDGETS_STATIC_DEFINE
#  define KICONWIDGETS_EXPORT
#  define KICONWIDGETS_NO_EXPORT
#else
#  ifndef KICONWIDGETS_EXPORT
#    ifdef KF6IconWidgets_EXPORTS
        /* We are building this library */
#      define KICONWIDGETS_EXPORT __declspec(dllexport)
#    else
        /* We are using this library */
#      define KICONWIDGETS_EXPORT __declspec(dllimport)
#    endif
#  endif

#  ifndef KICONWIDGETS_NO_EXPORT
#    define KICONWIDGETS_NO_EXPORT 
#  endif
#endif

#ifndef KICONWIDGETS_DECL_DEPRECATED
#  define KICONWIDGETS_DECL_DEPRECATED __declspec(deprecated)
#endif

#ifndef KICONWIDGETS_DECL_DEPRECATED_EXPORT
#  define KICONWIDGETS_DECL_DEPRECATED_EXPORT KICONWIDGETS_EXPORT KICONWIDGETS_DECL_DEPRECATED
#endif

#ifndef KICONWIDGETS_DECL_DEPRECATED_NO_EXPORT
#  define KICONWIDGETS_DECL_DEPRECATED_NO_EXPORT KICONWIDGETS_NO_EXPORT KICONWIDGETS_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KICONWIDGETS_NO_DEPRECATED
#    define KICONWIDGETS_NO_DEPRECATED
#  endif
#endif
#include <kiconthemes_version.h>

#define KICONWIDGETS_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

/* Take any defaults from group settings */
#if !defined(KICONWIDGETS_NO_DEPRECATED) && !defined(KICONWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KICONWIDGETS_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KICONWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KICONWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KICONWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KICONWIDGETS_NO_DEPRECATED_WARNINGS) && !defined(KICONWIDGETS_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KICONWIDGETS_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KICONWIDGETS_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KICONWIDGETS_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KICONWIDGETS_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KICONWIDGETS_NO_DEPRECATED)
#  undef KICONWIDGETS_DEPRECATED
#  define KICONWIDGETS_DEPRECATED_EXPORT KICONWIDGETS_EXPORT
#  define KICONWIDGETS_DEPRECATED_NO_EXPORT KICONWIDGETS_NO_EXPORT
#elif defined(KICONWIDGETS_NO_DEPRECATED_WARNINGS)
#  define KICONWIDGETS_DEPRECATED
#  define KICONWIDGETS_DEPRECATED_EXPORT KICONWIDGETS_EXPORT
#  define KICONWIDGETS_DEPRECATED_NO_EXPORT KICONWIDGETS_NO_EXPORT
#else
#  define KICONWIDGETS_DEPRECATED KICONWIDGETS_DECL_DEPRECATED
#  define KICONWIDGETS_DEPRECATED_EXPORT KICONWIDGETS_DECL_DEPRECATED_EXPORT
#  define KICONWIDGETS_DEPRECATED_NO_EXPORT KICONWIDGETS_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KICONWIDGETS_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KICONWIDGETS_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KICONWIDGETS_NO_DEPRECATED
#  define KICONWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT KICONTHEMES_VERSION
#endif
#ifdef KICONWIDGETS_NO_DEPRECATED_WARNINGS
#  define KICONWIDGETS_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KICONWIDGETS_DEPRECATED_WARNINGS_SINCE
#  ifdef KICONWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KICONWIDGETS_DEPRECATED_WARNINGS_SINCE KICONWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KICONWIDGETS_DEPRECATED_WARNINGS_SINCE KICONTHEMES_VERSION
#  endif
#endif

#ifndef KICONWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KICONWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KICONWIDGETS_DEPRECATED
#  define KICONWIDGETS_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KICONWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KICONWIDGETS_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* KICONWIDGETS_EXPORT_H */
