#ifndef _NETHANDLER_H_INCLUDED_
#define _NETHANDLER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// NetHandler.h
// ------------
// Net handler for sending and receiving messages
//                                                         
// (C)opyright 2000-2013 Bjoern Lemke
//
// Design and Implementation by Bjoern Lemke               
//
// INTERFACE MODULE
//
// Class: NetHandler
// 
// Description: Net handle for sending and receiving messages
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////


#include "Chain.h"
#include "ListT.h"

class NetHandler {
    
public:
    
    // NetHandler(int initMsgBufLen, int sizeInfoLen, int maxSendLen);
    NetHandler(int s, int initMsgBufLen, int sizeInfoLen, int maxSendLen);
    
    ~NetHandler();

    bool waitMsg(int ms);

    // void setSendTimeout(int ms);
    // void setRecvTimeout(int ms);

    int getSocket();
    
    void setSource(const Chain& source);
    const Chain& getSource() const;
    
    void writeMsg();
    void readMsg();


    void sendAck();
    void sendNack();
    bool recvAck();

    void sendChar(char c);
    char recvChar();
    
    char* getMsg();
    int getMsgSize();

    void setMsg(char* msg, int size);

    int concatPos();
    void concatReset();
    void concatAdd(const Chain& s);
    void concatAdd(char* msg, int size);

    void disconnect();
    
    NetHandler& operator = ( const NetHandler& nh);
    bool operator == ( const NetHandler& nh) const;

private:

    char* _msgBuf;
    int _msgBufSize;
    int _msgSize;
    int _sizeInfoLen;
    int _maxSendLen;
    int _socket;

    int _concatPos;

    Chain _source;
};

#endif
