if (CMAKE_VERSION VERSION_LESS 3.9)
  message (FATAL_ERROR "CMake >=  required")
endif (CMAKE_VERSION VERSION_LESS 3.9)


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was ng-log-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

####################################################################################

include (CMakeFindDependencyMacro)
include (${CMAKE_CURRENT_LIST_DIR}/ng-log-modules.cmake)

find_dependency (Threads)

find_dependency (gflags 2.2.2 NO_MODULE)
find_dependency (Unwind )


set(nglog_known_comps static shared)
set(nglog_comp_static NO)
set(nglog_comp_shared NO)
foreach (nglog_comp IN LISTS ${CMAKE_FIND_PACKAGE_NAME}_FIND_COMPONENTS)
    if (nglog_comp IN_LIST nglog_known_comps)
        set(nglog_comp_${nglog_comp} YES)
    else ()
        set(${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE
            "ng-log does not recognize component `${nglog_comp}`.")
        set(${CMAKE_FIND_PACKAGE_NAME}_FOUND FALSE)
        return()
    endif ()
endforeach ()

if (nglog_comp_static AND nglog_comp_shared)
    set(${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE
        "ng-log `static` and `shared` components are mutually exclusive.")
    set(${CMAKE_FIND_PACKAGE_NAME}_FOUND FALSE)
    return()
endif ()

set(nglog_static_targets "${CMAKE_CURRENT_LIST_DIR}/ng-log-static-targets.cmake")
set(nglog_shared_targets "${CMAKE_CURRENT_LIST_DIR}/ng-log-shared-targets.cmake")

macro(nglog_load_targets type)
    if (NOT EXISTS "${nglog_${type}_targets}")
        set(${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE
            "ng-log `${type}` libraries were requested but not found.")
        set(${CMAKE_FIND_PACKAGE_NAME}_FOUND FALSE)
        return()
    endif ()
    include("${nglog_${type}_targets}")
endmacro()

if (nglog_comp_static)
    nglog_load_targets(static)
elseif (nglog_comp_shared)
    nglog_load_targets(shared)
elseif (DEFINED ng_log_SHARED_LIBS AND ng_log_SHARED_LIBS)
    nglog_load_targets(shared)
elseif (DEFINED ng_log_SHARED_LIBS AND NOT ng_log_SHARED_LIBS)
    nglog_load_targets(static)
elseif (BUILD_SHARED_LIBS)
    if (EXISTS "${nglog_shared_targets}")
        nglog_load_targets(shared)
    else ()
        nglog_load_targets(static)
    endif ()
else ()
    if (EXISTS "${nglog_static_targets}")
        nglog_load_targets(static)
    else ()
        nglog_load_targets(shared)
    endif ()
endif ()
