%define OT_SamplingStrategy_doc
"Base class for directions sampling strategies.

Parameters
----------
dimension : int
    The dimension of the standard space.
    
    By default, :math:`dimension = 0` but
    automatically updated by the calling class.

See also
--------
RandomDirection, OrthogonalDirection"
%enddef
%feature("docstring") OT::SamplingStrategyImplementation
OT_SamplingStrategy_doc

// ---------------------------------------------------------------------

%define OT_SamplingStrategy_generate_doc
"Generate the directions.

Returns
-------
sample : :class:`~openturns.Sample`
    The directions generated  according to the sampling strategy.
    
Notes
-----
The sample is the collection of the points on the unit sphere in the standard space
associated to the generated directions."
%enddef
%feature("docstring") OT::SamplingStrategyImplementation::generate
OT_SamplingStrategy_generate_doc

// ---------------------------------------------------------------------

%define OT_SamplingStrategy_getDimension_doc
"Accessor to the dimension.

Returns
-------
dimension : int
    Dimension of the standard space."
%enddef
%feature("docstring") OT::SamplingStrategyImplementation::getDimension
OT_SamplingStrategy_getDimension_doc
    
// ---------------------------------------------------------------------

%define OT_SamplingStrategy_setDimension_doc
"Accessor to the dimension.

Parameters
----------
dimension : int
    Dimension of the standard space."
%enddef
%feature("docstring") OT::SamplingStrategyImplementation::setDimension
OT_SamplingStrategy_setDimension_doc


// ---------------------------------------------------------------------

%define OT_SamplingStrategy_getUniformUnitVectorRealization_doc
"Accessor to a realization according to the uniform distribution.

Parameters
----------
dimension : int
    The dimension of the sphere unity (which is the dimension of the standard
    space).

Returns
-------
sample : :class:`~openturns.Point`
    The realization of a vector on the sphere unity, according to the uniform
    distribution."
%enddef
%feature("docstring") OT::SamplingStrategyImplementation::getUniformUnitVectorRealization
OT_SamplingStrategy_getUniformUnitVectorRealization_doc
