# @HEADER
# ************************************************************************
#
#            TriBITS: Tribal Build, Integrate, and Test System
#                    Copyright 2013 Sandia Corporation
#
# Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
# the U.S. Government retains certain rights in this software.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
# 1. Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in the
# documentation and/or other materials provided with the distribution.
#
# 3. Neither the name of the Corporation nor the names of the
# contributors may be used to endorse or promote products derived from
# this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY SANDIA CORPORATION "AS IS" AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SANDIA CORPORATION OR THE
# CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
# PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# ************************************************************************
# @HEADER

##############################################################################
#
# CMake variable for use by Seacas/SEACAS clients.
#
# Do not edit: This file was generated automatically by CMake.
#
##############################################################################

if(CMAKE_VERSION VERSION_LESS 3.3)
  set(${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE
    "SEACAS requires CMake 3.3 or later for 'if (... IN_LIST ...)'"
    )
  set(${CMAKE_FIND_PACKAGE_NAME}_FOUND FALSE)
  return()
endif()
cmake_minimum_required(VERSION 3.3...3.22.0)

## ---------------------------------------------------------------------------
## Compilers used by Seacas/SEACAS build
## ---------------------------------------------------------------------------

set(SEACAS_CXX_COMPILER "${_IMPORT_PREFIX}/bin/clang++.exe")

set(SEACAS_C_COMPILER "${_IMPORT_PREFIX}/bin/clang.exe")

set(SEACAS_Fortran_COMPILER "gfortran")
# Deprecated!
set(SEACAS_FORTRAN_COMPILER "gfortran") 


## ---------------------------------------------------------------------------
## Compiler flags used by Seacas/SEACAS build
## ---------------------------------------------------------------------------

## Give the build type
set(SEACAS_CMAKE_BUILD_TYPE "Release")

## Set compiler flags, including those determined by build type
set(SEACAS_CXX_FLAGS [[ ]])

set(SEACAS_C_FLAGS [[-Wall -Wunused -pedantic -Wshadow -std=c11 ]])

set(SEACAS_Fortran_FLAGS [[ ]])
# Deprecated
set(SEACAS_FORTRAN_FLAGS [[ ]])

## Extra link flags (e.g., specification of fortran libraries)
set(SEACAS_EXTRA_LD_FLAGS [[]])

## This is the command-line entry used for setting rpaths. In a build
## with static libraries it will be empty.
set(SEACAS_SHARED_LIB_RPATH_COMMAND "${_IMPORT_PREFIX}/lib")
set(SEACAS_BUILD_SHARED_LIBS "ON")

set(SEACAS_LINKER ${_IMPORT_PREFIX}/bin/ld.lld.exe)
set(SEACAS_AR ${_IMPORT_PREFIX}/bin/llvm-ar.exe)

## ---------------------------------------------------------------------------
## Set library specifications and paths
## ---------------------------------------------------------------------------

## Base install location (if not in the build tree)
set(SEACAS_INSTALL_DIR "${_IMPORT_PREFIX}")

## List of package libraries
set(SEACAS_LIBRARIES SEACAS::all_libs)

## ---------------------------------------------------------------------------
## MPI specific variables
##   These variables are provided to make it easier to get the mpi libraries
##   and includes on systems that do not use the mpi wrappers for compiling
## ---------------------------------------------------------------------------

set(SEACAS_MPI_LIBRARIES "")
set(SEACAS_MPI_LIBRARY_DIRS "")
set(SEACAS_MPI_INCLUDE_DIRS "")
set(SEACAS_MPI_EXEC "")
set(SEACAS_MPI_EXEC_MAX_NUMPROCS "")
set(SEACAS_MPI_EXEC_NUMPROCS_FLAG "")

## ---------------------------------------------------------------------------
## Set useful general variables
## ---------------------------------------------------------------------------

# Enables/Disables for upstream package dependencies
set(SEACAS_ENABLE_SEACASExodus ON)
set(SEACAS_ENABLE_SEACASIoss ON)
set(SEACAS_ENABLE_SEACASExodus_for OFF)
set(SEACAS_ENABLE_SEACASExoIIv2for32 OFF)
set(SEACAS_ENABLE_SEACASNemesis ON)
set(SEACAS_ENABLE_SEACASChaco ON)
set(SEACAS_ENABLE_SEACASAprepro_lib ON)
set(SEACAS_ENABLE_SEACASSupes OFF)
set(SEACAS_ENABLE_SEACASSuplib OFF)
set(SEACAS_ENABLE_SEACASSuplibC ON)
set(SEACAS_ENABLE_SEACASSuplibCpp ON)
set(SEACAS_ENABLE_SEACASSVDI OFF)
set(SEACAS_ENABLE_SEACASPLT OFF)
set(SEACAS_ENABLE_SEACASAlgebra OFF)
set(SEACAS_ENABLE_SEACASAprepro ON)
set(SEACAS_ENABLE_SEACASBlot OFF)
set(SEACAS_ENABLE_SEACASConjoin ON)
set(SEACAS_ENABLE_SEACASEjoin ON)
set(SEACAS_ENABLE_SEACASEpu ON)
set(SEACAS_ENABLE_SEACASCpup ON)
set(SEACAS_ENABLE_SEACASExo2mat ON)
set(SEACAS_ENABLE_SEACASExodiff ON)
set(SEACAS_ENABLE_SEACASExomatlab ON)
set(SEACAS_ENABLE_SEACASExotxt OFF)
set(SEACAS_ENABLE_SEACASExo_format ON)
set(SEACAS_ENABLE_SEACASEx1ex2v2 OFF)
set(SEACAS_ENABLE_SEACASExotec2 OFF)
set(SEACAS_ENABLE_SEACASFastq OFF)
set(SEACAS_ENABLE_SEACASGjoin OFF)
set(SEACAS_ENABLE_SEACASGen3D OFF)
set(SEACAS_ENABLE_SEACASGenshell OFF)
set(SEACAS_ENABLE_SEACASGrepos OFF)
set(SEACAS_ENABLE_SEACASExplore OFF)
set(SEACAS_ENABLE_SEACASMapvarlib OFF)
set(SEACAS_ENABLE_SEACASMapvar OFF)
set(SEACAS_ENABLE_SEACASMapvar-kd OFF)
set(SEACAS_ENABLE_SEACASMat2exo ON)
set(SEACAS_ENABLE_SEACASNas2exo ON)
set(SEACAS_ENABLE_SEACASZellij ON)
set(SEACAS_ENABLE_SEACASNemslice ON)
set(SEACAS_ENABLE_SEACASNemspread ON)
set(SEACAS_ENABLE_SEACASNumbers OFF)
set(SEACAS_ENABLE_SEACASSlice ON)
set(SEACAS_ENABLE_SEACASTxtexo OFF)
set(SEACAS_ENABLE_SEACASEx2ex1v2 OFF)
set(SEACAS_ENABLE_MPI OFF)

# Exported cache variables
set(SEACAS_ENABLE_DEBUG "OFF")
set(HAVE_SEACAS_DEBUG "OFF")
set(SEACASExodus_ENABLE_THREADSAFE "YES")
set(EXODUS_THREADSAFE "ON")
set(SEACASIoss_ENABLE_THREADSAFE "YES")
set(IOSS_THREADSAFE "ON")

# Include configuration of dependent packages
if (NOT TARGET SEACASExodus::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../SEACASExodus/SEACASExodusConfig.cmake")
endif()
if (NOT TARGET SEACASIoss::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../SEACASIoss/SEACASIossConfig.cmake")
endif()
if (NOT TARGET SEACASNemesis::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../SEACASNemesis/SEACASNemesisConfig.cmake")
endif()
if (NOT TARGET SEACASChaco::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../SEACASChaco/SEACASChacoConfig.cmake")
endif()
if (NOT TARGET SEACASAprepro_lib::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../SEACASAprepro_lib/SEACASAprepro_libConfig.cmake")
endif()
if (NOT TARGET SEACASSuplibC::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../SEACASSuplibC/SEACASSuplibCConfig.cmake")
endif()
if (NOT TARGET SEACASSuplibCpp::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../SEACASSuplibCpp/SEACASSuplibCppConfig.cmake")
endif()
if (NOT TARGET SEACASAprepro::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../SEACASAprepro/SEACASApreproConfig.cmake")
endif()
if (NOT TARGET SEACASConjoin::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../SEACASConjoin/SEACASConjoinConfig.cmake")
endif()
if (NOT TARGET SEACASEjoin::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../SEACASEjoin/SEACASEjoinConfig.cmake")
endif()
if (NOT TARGET SEACASEpu::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../SEACASEpu/SEACASEpuConfig.cmake")
endif()
if (NOT TARGET SEACASCpup::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../SEACASCpup/SEACASCpupConfig.cmake")
endif()
if (NOT TARGET SEACASExo2mat::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../SEACASExo2mat/SEACASExo2matConfig.cmake")
endif()
if (NOT TARGET SEACASExodiff::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../SEACASExodiff/SEACASExodiffConfig.cmake")
endif()
if (NOT TARGET SEACASExomatlab::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../SEACASExomatlab/SEACASExomatlabConfig.cmake")
endif()
if (NOT TARGET SEACASExo_format::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../SEACASExo_format/SEACASExo_formatConfig.cmake")
endif()
if (NOT TARGET SEACASMat2exo::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../SEACASMat2exo/SEACASMat2exoConfig.cmake")
endif()
if (NOT TARGET SEACASNas2exo::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../SEACASNas2exo/SEACASNas2exoConfig.cmake")
endif()
if (NOT TARGET SEACASZellij::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../SEACASZellij/SEACASZellijConfig.cmake")
endif()
if (NOT TARGET SEACASNemslice::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../SEACASNemslice/SEACASNemsliceConfig.cmake")
endif()
if (NOT TARGET SEACASNemspread::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../SEACASNemspread/SEACASNemspreadConfig.cmake")
endif()
if (NOT TARGET SEACASSlice::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../SEACASSlice/SEACASSliceConfig.cmake")
endif()

# Import SEACAS targets
include("${CMAKE_CURRENT_LIST_DIR}/SEACASTargets.cmake")

# Standard TriBITS-compliant external package variables
set(SEACAS_IS_TRIBITS_COMPLIANT TRUE)
set(SEACAS_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE "${CMAKE_CURRENT_LIST_FILE}")
set(SEACAS_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE_DIR "${CMAKE_CURRENT_LIST_DIR}")


## ----------------------------------------------------------------------------
## Create deprecated non-namespaced library targets for backwards compatibility
## ----------------------------------------------------------------------------

set(SEACAS_EXPORTED_PACKAGE_LIBS_NAMES "exodus;nemesis;Ioex;Ioexnl;Ionull;Iovs;Iogn;Iotm;Iogs;Iohb;Iotr;Ionit;io_info_lib;Ioss;chaco;aprepro_lib;suplib_c;suplib_cpp")

foreach(libname IN LISTS SEACAS_EXPORTED_PACKAGE_LIBS_NAMES)
  if (NOT TARGET ${libname})
    add_library(${libname} INTERFACE IMPORTED)
    target_link_libraries(${libname}
       INTERFACE SEACAS::${libname})
    set(deprecationMessage
      "WARNING: The non-namespaced target '${libname}' is deprecated!"
      "  If always using newer versions of the project 'Seacas', then use the"
      " new namespaced target 'SEACAS::${libname}', or better yet,"
      " 'SEACAS::all_libs' to be less sensitive to changes in the definition"
      " of targets in the package 'SEACAS'.  Or, to maintain compatibility with"
      " older or newer versions the project 'Seacas', instead link against the"
      " libraries specified by the variable 'SEACAS_LIBRARIES'."
      )
    string(REPLACE ";" "" deprecationMessage "${deprecationMessage}")
    set_target_properties(${libname}
      PROPERTIES DEPRECATION "${deprecationMessage}" )
  endif()
endforeach()
