#ifndef _CEGOCLOB_H_INCLUDED_
#define _CEGOCLOB_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoClob.h
// ----------
// Cego clob definition
//                                                         
// Design and Implementation by Bjoern Lemke               
//     
// (C)opyright 2000-2019 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoClob
//
// Description: Character large object container class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>

#include "CegoDefs.h"

class CegoClob {

public:
  
    CegoClob();  
    CegoClob(PageIdType pageId);
    CegoClob(char *clobBuf, unsigned long long clobSize);  
    CegoClob(PageIdType pageId, char *clobBuf, unsigned long long clobSize);  
    ~CegoClob();

    void readClob(const Chain& fileName);
    void writeClob(const Chain& fileName);
    
    unsigned long long getSize() const;
    char* getBufPtr();

    void allocate(unsigned long long size);
    void release();
    
    void reset();

    bool nextChunk(unsigned long long chunkSize);
    void putChunk(char *chunkBuf, unsigned long long chunkSize);
    char* getChunkPtr();
    unsigned long long getChunkSize();

    void setPageId(PageIdType pageId);
    PageIdType getPageId() const;

    Chain getHead() const;
    
    CegoClob& operator = ( const CegoClob& b);
    bool operator == ( const CegoClob& b);

    Chain toChain() const;
    Chain valAsChain() const;
    friend ostream& operator << (ostream& s, const CegoClob& b);
    
private:

    PageIdType _pageId;

    unsigned long long _size;
    char *_buf;

    unsigned long long _chunkSize;
    char *_chunkPtr;

};

#endif
