/*
 *  Copyright 2008-2014 NVIDIA Corporation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/*! \file config.h
 *  \brief Defines platform configuration.
 */

#pragma once

#include <thrust/detail/config.h>
#include <thrust/version.h>

#include <cusp/version.h>
#include <cusp/detail/config/host_system.h>
#include <cusp/detail/config/device_system.h>
#include <cusp/detail/config/host_blas_system.h>
#include <cusp/detail/config/device_blas_system.h>

// Cusp supports Thrust v1.5 and above
#if THRUST_VERSION < 100500
#error "Thrust v1.5.0 or newer is required"
#endif

// decorator for deprecated features
#define CUSP_DEPRECATED THRUST_DEPRECATED
