/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpselection_pdb.h
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#if !defined (__GIMP_H_INSIDE__) && !defined (GIMP_COMPILATION)
#error "Only <libgimp/gimp.h> can be included directly."
#endif

#ifndef __GIMP_SELECTION_PDB_H__
#define __GIMP_SELECTION_PDB_H__

G_BEGIN_DECLS

/* For information look into the C source or the html documentation */


gboolean                   gimp_selection_bounds    (GimpImage       *image,
                                                     gboolean        *non_empty,
                                                     gint            *x1,
                                                     gint            *y1,
                                                     gint            *x2,
                                                     gint            *y2);
gint                       gimp_selection_value     (GimpImage       *image,
                                                     gint             x,
                                                     gint             y);
gboolean                   gimp_selection_is_empty  (GimpImage       *image);
gboolean                   gimp_selection_translate (GimpImage       *image,
                                                     gint             offx,
                                                     gint             offy);
G_GNUC_INTERNAL GimpLayer* _gimp_selection_float    (gint             num_drawables,
                                                     const GimpItem **drawables,
                                                     gint             offx,
                                                     gint             offy);
gboolean                   gimp_selection_invert    (GimpImage       *image);
gboolean                   gimp_selection_sharpen   (GimpImage       *image);
gboolean                   gimp_selection_all       (GimpImage       *image);
gboolean                   gimp_selection_none      (GimpImage       *image);
gboolean                   gimp_selection_feather   (GimpImage       *image,
                                                     gdouble          radius);
gboolean                   gimp_selection_border    (GimpImage       *image,
                                                     gint             radius);
gboolean                   gimp_selection_grow      (GimpImage       *image,
                                                     gint             steps);
gboolean                   gimp_selection_shrink    (GimpImage       *image,
                                                     gint             steps);
gboolean                   gimp_selection_flood     (GimpImage       *image);
GimpChannel*               gimp_selection_save      (GimpImage       *image);


G_END_DECLS

#endif /* __GIMP_SELECTION_PDB_H__ */
