/* BEGIN_LEGAL 

Copyright (c) 2025 Intel Corporation

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
  
END_LEGAL */
/// @file xed-machine-mode-enum.h

// This file was automatically generated.
// Do not edit this file.

#if !defined(XED_MACHINE_MODE_ENUM_H)
# define XED_MACHINE_MODE_ENUM_H
#include "xed-common-hdrs.h"
#define XED_MACHINE_MODE_INVALID_DEFINED 1
#define XED_MACHINE_MODE_LONG_64_DEFINED 1
#define XED_MACHINE_MODE_LONG_COMPAT_32_DEFINED 1
#define XED_MACHINE_MODE_LONG_COMPAT_16_DEFINED 1
#define XED_MACHINE_MODE_LEGACY_32_DEFINED 1
#define XED_MACHINE_MODE_LEGACY_16_DEFINED 1
#define XED_MACHINE_MODE_REAL_16_DEFINED 1
#define XED_MACHINE_MODE_REAL_32_DEFINED 1
#define XED_MACHINE_MODE_LAST_DEFINED 1
typedef enum {
  XED_MACHINE_MODE_INVALID,
  XED_MACHINE_MODE_LONG_64, ///< 64b operating mode
  XED_MACHINE_MODE_LONG_COMPAT_32, ///< 32b protected mode
  XED_MACHINE_MODE_LONG_COMPAT_16, ///< 16b protected mode
  XED_MACHINE_MODE_LEGACY_32, ///< 32b protected mode
  XED_MACHINE_MODE_LEGACY_16, ///< 16b protected mode
  XED_MACHINE_MODE_REAL_16, ///< 16b real mode
  XED_MACHINE_MODE_REAL_32, ///< 32b real mode (CS.D bit = 1)
  XED_MACHINE_MODE_LAST
} xed_machine_mode_enum_t;

/// This converts strings to #xed_machine_mode_enum_t types.
/// @param s A C-string.
/// @return #xed_machine_mode_enum_t
/// @ingroup ENUM
XED_DLL_EXPORT xed_machine_mode_enum_t str2xed_machine_mode_enum_t(const char* s);
/// This converts strings to #xed_machine_mode_enum_t types.
/// @param p An enumeration element of type xed_machine_mode_enum_t.
/// @return string
/// @ingroup ENUM
XED_DLL_EXPORT const char* xed_machine_mode_enum_t2str(const xed_machine_mode_enum_t p);

/// Returns the last element of the enumeration
/// @return xed_machine_mode_enum_t The last element of the enumeration.
/// @ingroup ENUM
XED_DLL_EXPORT xed_machine_mode_enum_t xed_machine_mode_enum_t_last(void);
#endif
