/*/////////////////////////////////////////////////////////////////////////////////
/// An
///    ___   ____ ___ _____ ___  ____
///   / _ \ / ___|_ _|_   _/ _ \|  _ \
///  | | | | |  _ | |  | || | | | |_) |
///  | |_| | |_| || |  | || |_| |  _ <
///   \___/ \____|___| |_| \___/|_| \_\
///                              File
///
/// Copyright (c) 2008-2015 Ismail TARIM <ismail@royalspor.com> and the Ogitor Team
///
/// The MIT License
///
/// Permission is hereby granted, free of charge, to any person obtaining a copy
/// of this software and associated documentation files (the "Software"), to deal
/// in the Software without restriction, including without limitation the rights
/// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
/// copies of the Software, and to permit persons to whom the Software is
/// furnished to do so, subject to the following conditions:
///
/// The above copyright notice and this permission notice shall be included in
/// all copies or substantial portions of the Software.
///
/// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
/// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
/// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
/// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
/// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
/// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
/// THE SOFTWARE.
////////////////////////////////////////////////////////////////////////////////*/

#pragma once

#if OGRE_COMPILER == OGRE_COMPILER_MSVC
// Turn off warnings generated by this singleton implementation
#   pragma warning (disable : 4311)
#   pragma warning (disable : 4312)
#endif

#if defined ( OGRE_GCC_VISIBILITY )
#   pragma GCC visibility push(default)
#endif

namespace Ogitors
{
    //! Singleton class
    /*!  
        Template class for creating single-instance global classes.
    */
    template <typename T> class Singleton
    {
    protected:

        static T* ms_Singleton;             /** Handle to singleton-derived object */

    public:
        /**
        * Constructor
        */
        Singleton()
        {
            assert( !ms_Singleton );
#if defined( _MSC_VER ) && _MSC_VER < 1200
            int offset = (int)(T*)1 - (int)(Singleton <T>*)(T*)1;
            ms_Singleton = (T*)((int)this + offset);
#else
        ms_Singleton = static_cast< T* >( this );
#endif
        }
        /**
        * Destructor
        */
        ~Singleton()
         {  
             assert( ms_Singleton );  
             ms_Singleton = 0;  
        }
        /**
        * Fetches singleton-derived object
        * @return singleton-derived object
        */
        static T& getSingleton()
        {    
            assert( ms_Singleton );  
            return ( *ms_Singleton ); 
        }
        
        /**
        * Fetches handle of singleton-derived object
        * @return handle of singleton-derived object
        */
        static T* getSingletonPtr()
        { 
            return ms_Singleton; 
        }
    };
}
#if defined ( OGRE_GCC_VISIBILITY )
#   pragma GCC visibility pop
#endif
