%define OT_SobolIndicesAlgorithm_doc
"
Sensitivity analysis.

Notes
-----
This method measures the influence of each component of an input random vector
:math:`\\vect{X} = \\left( X_1, \\ldots, X_{n_X} \\right)` on an output random vector
:math:`\\vect{Y} = \\left( Y_1, \\ldots, Y_{n_Y} \\right)` by computing Sobol' indices (see [sobol1993]_).
It computes, for every output random variable :math:`Y_k` (:math:`1 \\leqslant k \\leqslant n_Y`),
the part of its variance due to each input component :math:`X_i` (:math:`1 \\leqslant i \\leqslant n_X`) of :math:`\\vect{X}`.
Sobol' indices are introduced in :ref:`sensitivity_sobol`. 

Several estimators of :math:`V_i`, :math:`V_i^T` and :math:`V_{-i}` are provided by the :class:`SobolIndicesAlgorithm` implementations:

- :class:`~openturns.SaltelliSensitivityAlgorithm` for the `Saltelli` method,
- :class:`~openturns.JansenSensitivityAlgorithm` for the `Jansen` method,
- :class:`~openturns.MauntzKucherenkoSensitivityAlgorithm` for the `Mauntz-Kucherenko` method,
- :class:`~openturns.MartinezSensitivityAlgorithm` for the `Martinez` method.

Specific formulas for :math:`\\widehat{V}_i`, :math:`\\widehat{V}_i^T` and :math:`\\widehat{V}_{-i}` are given in the corresponding documentation pages.


For multivariate outputs i.e. when :math:`n_Y>1`, we compute the Sobol' indices with respect to each output variable. 
In this case, the methods :meth:`getFirstOrderIndices` and 
:meth:`getTotalOrderIndices` return the Sobol' indices of the first output, 
but the index of the output can be specified as input argument.
Aggregated indices can be retrieved with the :meth:`getAggregatedFirstOrderIndices` 
and :meth:`getAggregatedTotalOrderIndices` methods. 


Notice that the distribution of the estimators of the first
and total order indices can be estimated
thanks to the :meth:`getFirstOrderIndicesDistribution` and
:meth:`getTotalOrderIndicesDistribution` methods.
This is done either through bootstrapping or using an asymptotic estimator.
The :class:`~openturns.ResourceMap` key `SobolIndicesAlgorithm-DefaultUseAsymptoticDistribution`
stores a boolean that decides the default behavior,
but it can be overridden by the method :meth:`setUseAsymptoticDistribution`.

Corresponding confidence intervals are provided by the methods
:meth:`getFirstOrderIndicesInterval` and :meth:`getTotalOrderIndicesInterval`.
Their confidence level can be adjusted with :meth:`setConfidenceLevel`.
The default confidence level is stored in the :class:`~openturns.ResourceMap`
and can be accessed with the `SobolIndicesAlgorithm-DefaultConfidenceLevel` key.

Indices estimates can be slightly outside of [0,1] if the estimator has not converged.
For the same reason some first order indices estimates can be greater than the corresponding total order indices estimates.

The asymptotic estimator of the distribution requires an asymptotic estimate
of its variance, which is computed using the [janon2014]_
delta method, as expained in the technical report [pmfre01116]_.
"
%enddef
%feature("docstring") OT::SobolIndicesAlgorithmImplementation
OT_SobolIndicesAlgorithm_doc

// ---------------------------------------------------------------------

%define OT_SobolIndicesAlgorithm_getFirstOrderIndices_doc
"Get first order Sobol indices.

Parameters
----------
i : int, optional
    Index of the output marginal of the function, equal to :math:`0` by default.

Returns
-------
indices : :class:`~openturns.Point`
    Sequence containing first order Sobol indices."
%enddef
%feature("docstring") OT::SobolIndicesAlgorithmImplementation::getFirstOrderIndices
OT_SobolIndicesAlgorithm_getFirstOrderIndices_doc

// ---------------------------------------------------------------------

%define OT_SobolIndicesAlgorithm_getFirstOrderIndicesInterval_doc
"Get interval for the aggregated first order Sobol indices.

Returns
-------
interval : :class:`~openturns.Interval`
    Interval for first order Sobol indices for each component.
    Computed marginal by marginal (not from the joint distribution)."
%enddef
%feature("docstring") OT::SobolIndicesAlgorithmImplementation::getFirstOrderIndicesInterval
OT_SobolIndicesAlgorithm_getFirstOrderIndicesInterval_doc

// ---------------------------------------------------------------------

%define OT_SobolIndicesAlgorithm_getAggregatedFirstOrderIndices_doc
"Get the evaluation of aggregated first order Sobol indices.

Returns
-------
indices : :class:`~openturns.Point`
    Sequence containing aggregated first order Sobol indices."
%enddef
%feature("docstring") OT::SobolIndicesAlgorithmImplementation::getAggregatedFirstOrderIndices
OT_SobolIndicesAlgorithm_getAggregatedFirstOrderIndices_doc

// ---------------------------------------------------------------------

%define OT_SobolIndicesAlgorithm_getAggregatedTotalOrderIndices_doc
"Get the evaluation of aggregated total order Sobol indices.

Returns
-------
indices : :class:`~openturns.Point`
    Sequence containing aggregated total order Sobol indices."

%enddef
%feature("docstring") OT::SobolIndicesAlgorithmImplementation::getAggregatedTotalOrderIndices
OT_SobolIndicesAlgorithm_getAggregatedTotalOrderIndices_doc

// ---------------------------------------------------------------------

%define OT_SobolIndicesAlgorithm_getSecondOrderIndices_doc
"Get second order Sobol indices.

Parameters
----------
i : int, optional
    Index of the marginal of the function, equals to :math:`0` by default.

Returns
-------
indices : :class:`~openturns.SymmetricMatrix`
    Tensor containing second order Sobol indices."
%enddef
%feature("docstring") OT::SobolIndicesAlgorithmImplementation::getSecondOrderIndices
OT_SobolIndicesAlgorithm_getSecondOrderIndices_doc

// ---------------------------------------------------------------------

%define OT_SobolIndicesAlgorithm_getTotalOrderIndices_doc
"Get total order Sobol indices.

Parameters
----------
i : int, optional
    Index of the output marginal of the function, equal to :math:`0` by default.

Returns
-------
indices : :class:`~openturns.Point`
    Sequence containing total order Sobol indices."

%enddef
%feature("docstring") OT::SobolIndicesAlgorithmImplementation::getTotalOrderIndices
OT_SobolIndicesAlgorithm_getTotalOrderIndices_doc

// ---------------------------------------------------------------------

%define OT_SobolIndicesAlgorithm_getTotalOrderIndicesInterval_doc
"Get interval for the aggregated total order Sobol indices.

Returns
-------
interval : :class:`~openturns.Interval`
    Interval for total order Sobol indices for each component.
    Computed marginal by marginal (not from the joint distribution)."
%enddef
%feature("docstring") OT::SobolIndicesAlgorithmImplementation::getTotalOrderIndicesInterval
OT_SobolIndicesAlgorithm_getTotalOrderIndicesInterval_doc

// ---------------------------------------------------------------------

%define OT_SobolIndicesAlgorithm_getConfidenceLevel_doc
"Get the confidence interval level for confidence intervals.

Returns
-------
confidenceLevel : float
    Confidence level for confidence intervals"
%enddef
%feature("docstring") OT::SobolIndicesAlgorithmImplementation::getConfidenceLevel
OT_SobolIndicesAlgorithm_getConfidenceLevel_doc

// ---------------------------------------------------------------------

%define OT_SobolIndicesAlgorithm_setConfidenceLevel_doc
"Set the confidence interval level for confidence intervals.

Parameters
----------
confidenceLevel : float
    Confidence level for confidence intervals"
%enddef
%feature("docstring") OT::SobolIndicesAlgorithmImplementation::setConfidenceLevel
OT_SobolIndicesAlgorithm_setConfidenceLevel_doc

// ---------------------------------------------------------------------

%define OT_SobolIndicesAlgorithm_getBootstrapSize_doc
"Get the number of bootstrap sampling size.

Returns
-------
bootstrapSize : int
    Number of bootstrap sampling"
%enddef
%feature("docstring") OT::SobolIndicesAlgorithmImplementation::getBootstrapSize
OT_SobolIndicesAlgorithm_getBootstrapSize_doc

// ---------------------------------------------------------------------

%define OT_SobolIndicesAlgorithm_setBootstrapSize_doc
"Set the number of bootstrap sampling size.

Default value is 0.

Parameters
----------
bootstrapSize : int
    Number of bootstrap sampling"
%enddef
%feature("docstring") OT::SobolIndicesAlgorithmImplementation::setBootstrapSize
OT_SobolIndicesAlgorithm_setBootstrapSize_doc

// ---------------------------------------------------------------------
%define OT_SobolIndicesAlgorithm_draw_doc
"Draw sensitivity indices.

Usage:
  draw()

  draw(*marginalIndex*)

With the first usage, draw the aggregated first and total order indices.
With the second usage, draw the first and total order indices of a specific marginal in case of vectorial output

Parameters
----------
marginalIndex: int
    marginal of interest (case of second usage)

Returns
-------
graph : :class:`~openturns.Graph`
    A graph containing the aggregated first and total order indices.

Notes
-----
If number of bootstrap sampling is not 0, and confidence level associated > 0,
the graph includes confidence interval plots in the first usage."
%enddef
%feature("docstring") OT::SobolIndicesAlgorithmImplementation::draw
OT_SobolIndicesAlgorithm_draw_doc

// ---------------------------------------------------------------------

%define OT_SobolIndicesAlgorithm_DrawCorrelationCoefficients_doc
"Draw the correlation coefficients. 
 As correlation coefficients are considered, values might be positive or negative.

Available usages:
    DrawCorrelationCoefficients(*correlationCoefficients, title='Correlation coefficients'*)

    DrawCorrelationCoefficients(*values, names, title='Correlation coefficients'*)

Parameters
----------
correlationCoefficients : :class:`~openturns.PointWithDescription`
    Sequence containing the correlation coefficients with a description for each
    component. The descriptions are used to build labels for the created graph.
    If they are not mentioned, default labels will be used.
values : sequence of float
    Correlation coefficients.
names : sequence of str
    Variables' names used to build labels for the created the graph.
title : str
    Title of the graph.

Returns
-------
graph : :class:`~openturns.Graph`
    A graph containing a :class:`~openturns.Cloud` and a :class:`~openturns.Text` 
    of the correlation coefficients."
%enddef
%feature("docstring") OT::SobolIndicesAlgorithmImplementation::DrawCorrelationCoefficients
OT_SobolIndicesAlgorithm_DrawCorrelationCoefficients_doc

// ---------------------------------------------------------------------

%define OT_SobolIndicesAlgorithm_DrawImportanceFactors_doc
"Draw the importance factors.

Available usages:
    DrawImportanceFactors(*importanceFactors, title='Importance Factors'*)

    DrawImportanceFactors(*values, names, title='Importance Factors'*)

Parameters
----------
importanceFactors : :class:`~openturns.PointWithDescription`
    Sequence containing the importance factors with a description for each
    component. The descriptions are used to build labels for the created Pie.
    If they are not mentioned, default labels will be used.
values : sequence of float
    Importance factors.
names : sequence of str
    Variables' names used to build labels for the created Pie.
title : str
    Title of the graph.

Returns
-------
graph : :class:`~openturns.Graph`
    A graph containing a :class:`~openturns.Pie` of the importance factors of
    the variables."
%enddef
%feature("docstring") OT::SobolIndicesAlgorithmImplementation::DrawImportanceFactors
OT_SobolIndicesAlgorithm_DrawImportanceFactors_doc

// ---------------------------------------------------------------------

%define OT_SobolIndicesAlgorithm_DrawSobolIndices_doc
"Draw the Sobol' indices.

Parameters
----------
inputDescription : sequence of str
    Variable names
firstOrderIndices : sequence of float
    First order indices values
totalOrderIndices : sequence of float
    Total order indices values
fo_ci : :class:`~openturns.Interval`, optional
    First order indices confidence interval
to_ci : :class:`~openturns.Interval`, optional
    Total order indices confidence interval

Returns
-------
graph : :class:`~openturns.Graph`
    For each variable, draws first and total indices"
%enddef
%feature("docstring") OT::SobolIndicesAlgorithmImplementation::DrawSobolIndices
OT_SobolIndicesAlgorithm_DrawSobolIndices_doc

// ---------------------------------------------------------------------

%define OT_SobolIndicesAlgorithm_getUseAsymptoticDistribution_doc
"Select asymptotic or bootstrap confidence intervals.

Returns
-------
useAsymptoticDistribution : bool
    Whether to use bootstrap or asymptotic intervals"
%enddef
%feature("docstring") OT::SobolIndicesAlgorithmImplementation::getUseAsymptoticDistribution
OT_SobolIndicesAlgorithm_getUseAsymptoticDistribution_doc

// ---------------------------------------------------------------------

%define OT_SobolIndicesAlgorithm_setUseAsymptoticDistribution_doc
"Select asymptotic or bootstrap confidence intervals.

Default value is set by the `SobolIndicesAlgorithm-DefaultUseAsymptoticDistribution` key.

Parameters
----------
useAsymptoticDistribution : bool
    Whether to use bootstrap or asymptotic intervals"
%enddef
%feature("docstring") OT::SobolIndicesAlgorithmImplementation::setUseAsymptoticDistribution
OT_SobolIndicesAlgorithm_setUseAsymptoticDistribution_doc

// ---------------------------------------------------------------------

%define OT_SobolIndicesAlgorithm_getFirstOrderIndicesDistribution_doc
"Get the distribution of the aggregated first order Sobol indices.

Returns
-------
distribution : :class:`~openturns.Distribution`
    Distribution for first order Sobol indices for each component."
%enddef
%feature("docstring") OT::SobolIndicesAlgorithmImplementation::getFirstOrderIndicesDistribution
OT_SobolIndicesAlgorithm_getFirstOrderIndicesDistribution_doc

// ---------------------------------------------------------------------

%define OT_SobolIndicesAlgorithm_getTotalOrderIndicesDistribution_doc
"Get the distribution of the aggregated total order Sobol indices.

Returns
-------
distribution : :class:`~openturns.Distribution`
    Distribution for total order Sobol indices for each component."
%enddef
%feature("docstring") OT::SobolIndicesAlgorithmImplementation::getTotalOrderIndicesDistribution
OT_SobolIndicesAlgorithm_getTotalOrderIndicesDistribution_doc

// ---------------------------------------------------------------------

%define OT_SobolIndicesAlgorithm_setDesign_doc
"Sample accessor.

Allows one to estimate indices from a predefined Sobol design.

Parameters
----------
inputDesign : :class:`~openturns.Sample`
    Design for the evaluation of sensitivity indices, obtained
    thanks to the SobolIndicesAlgorithmImplementation.Generate method
outputDesign : :class:`~openturns.Sample`
    Design for the evaluation of sensitivity indices, obtained as the evaluation
    of a Function (model) on the previous inputDesign
N : int
    Base size of the Sobol design"
%enddef
%feature("docstring") OT::SobolIndicesAlgorithmImplementation::setDesign
OT_SobolIndicesAlgorithm_setDesign_doc

