#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmarkboundaryfaces_ DMPLEXMARKBOUNDARYFACES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmarkboundaryfaces_ dmplexmarkboundaryfaces
#endif
PETSC_EXTERN void dmplexmarkboundaryfaces_(DM *a, PetscInt *b, DMLabel *c, PetscErrorCode *ierr)
{
  *ierr = DMPlexMarkBoundaryFaces(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexlabelcomplete_ DMPLEXLABELCOMPLETE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexlabelcomplete_ dmplexlabelcomplete
#endif
PETSC_EXTERN void dmplexlabelcomplete_(DM *a, DMLabel *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexLabelComplete(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexlabeladdcells_ DMPLEXLABELADDCELLS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexlabeladdcells_ dmplexlabeladdcells
#endif
PETSC_EXTERN void dmplexlabeladdcells_(DM *a, DMLabel *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexLabelAddCells(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexlabeladdfacecells_ DMPLEXLABELADDFACECELLS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexlabeladdfacecells_ dmplexlabeladdfacecells
#endif
PETSC_EXTERN void dmplexlabeladdfacecells_(DM *a, DMLabel *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexLabelAddFaceCells(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexlabelclearcells_ DMPLEXLABELCLEARCELLS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexlabelclearcells_ dmplexlabelclearcells
#endif
PETSC_EXTERN void dmplexlabelclearcells_(DM *a, DMLabel *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexLabelClearCells(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexconstructghostcells_ DMPLEXCONSTRUCTGHOSTCELLS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexconstructghostcells_ dmplexconstructghostcells
#endif
PETSC_EXTERN void dmplexconstructghostcells_(DM *a, char b[], PetscInt *c, DM *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMPlexConstructGhostCells(*a, c_b, c, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexconstructcohesivecells_ DMPLEXCONSTRUCTCOHESIVECELLS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexconstructcohesivecells_ dmplexconstructcohesivecells
#endif
PETSC_EXTERN void dmplexconstructcohesivecells_(DM *a, DMLabel *b, DMLabel *c, DM *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMPlexConstructCohesiveCells(*a, *b, *c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexlabelcohesivecomplete_ DMPLEXLABELCOHESIVECOMPLETE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexlabelcohesivecomplete_ dmplexlabelcohesivecomplete
#endif
PETSC_EXTERN void dmplexlabelcohesivecomplete_(DM *a, DMLabel *b, DMLabel *c, PetscInt *d, PetscBool *e, PetscBool *f, DM *g, PetscErrorCode *ierr)
{
  *ierr = DMPlexLabelCohesiveComplete(*a, *b, *c, *d, *e ? PETSC_TRUE : PETSC_FALSE, *f ? PETSC_TRUE : PETSC_FALSE, *g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreatehybridmesh_ DMPLEXCREATEHYBRIDMESH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreatehybridmesh_ dmplexcreatehybridmesh
#endif
PETSC_EXTERN void dmplexcreatehybridmesh_(DM *a, DMLabel *b, DMLabel *c, PetscInt *d, DMLabel *e, DMLabel *f, DM *g, DM *h, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_g = !*(void**) g ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_h = !*(void**) h ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(e);
  CHKFORTRANNULLOBJECT(f);
  CHKFORTRANNULLOBJECT(g);
  CHKFORTRANNULLOBJECT(h);
  *ierr = DMPlexCreateHybridMesh(*a, *b, *c, *d, e, f, g, h);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
  if (! null_g && !*(void**) g) *(void **) g = (void *)-2;
  if (! null_h && !*(void**) h) *(void **) h = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetorientedface_ DMPLEXGETORIENTEDFACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetorientedface_ dmplexgetorientedface
#endif
PETSC_EXTERN void dmplexgetorientedface_(DM *a, PetscInt *b, PetscInt *c, const PetscInt d[], PetscInt *e, PetscInt f[], PetscInt g[], PetscInt h[], PetscBool *i, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(f);
  CHKFORTRANNULLINTEGER(g);
  CHKFORTRANNULLINTEGER(h);
  CHKFORTRANNULLBOOL(i);
  *ierr = DMPlexGetOrientedFace(*a, *b, *c, d, *e, f, g, h, i);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreatesubmesh_ DMPLEXCREATESUBMESH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreatesubmesh_ dmplexcreatesubmesh
#endif
PETSC_EXTERN void dmplexcreatesubmesh_(DM *a, DMLabel *b, PetscInt *c, PetscBool *d, DM *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(e);
  *ierr = DMPlexCreateSubmesh(*a, *b, *c, *d ? PETSC_TRUE : PETSC_FALSE, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreatecohesivesubmesh_ DMPLEXCREATECOHESIVESUBMESH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreatecohesivesubmesh_ dmplexcreatecohesivesubmesh
#endif
PETSC_EXTERN void dmplexcreatecohesivesubmesh_(DM *a, PetscBool *b, char c[], PetscInt *d, DM *e, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  CHKFORTRANNULLOBJECT(e);
  *ierr = DMPlexCreateCohesiveSubmesh(*a, *b ? PETSC_TRUE : PETSC_FALSE, c_c, *d, e);
  if (*ierr) return;
  FREECHAR(c, c_c);
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexreordercohesivesupports_ DMPLEXREORDERCOHESIVESUPPORTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexreordercohesivesupports_ dmplexreordercohesivesupports
#endif
PETSC_EXTERN void dmplexreordercohesivesupports_(DM *a, PetscErrorCode *ierr)
{
  *ierr = DMPlexReorderCohesiveSupports(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexfilter_ DMPLEXFILTER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexfilter_ dmplexfilter
#endif
PETSC_EXTERN void dmplexfilter_(DM *a, DMLabel *b, PetscInt *c, PetscBool *d, PetscBool *e, PetscSF *f, DM *g, PetscErrorCode *ierr)
{
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_g = !*(void**) g ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(f);
  CHKFORTRANNULLOBJECT(g);
  *ierr = DMPlexFilter(*a, *b, *c, *d ? PETSC_TRUE : PETSC_FALSE, *e ? PETSC_TRUE : PETSC_FALSE, f, g);
  if (*ierr) return;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
  if (! null_g && !*(void**) g) *(void **) g = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetsubpointmap_ DMPLEXGETSUBPOINTMAP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetsubpointmap_ dmplexgetsubpointmap
#endif
PETSC_EXTERN void dmplexgetsubpointmap_(DM *a, DMLabel *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMPlexGetSubpointMap(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsetsubpointmap_ DMPLEXSETSUBPOINTMAP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsetsubpointmap_ dmplexsetsubpointmap
#endif
PETSC_EXTERN void dmplexsetsubpointmap_(DM *a, DMLabel *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexSetSubpointMap(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetsubpointis_ DMPLEXGETSUBPOINTIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetsubpointis_ dmplexgetsubpointis
#endif
PETSC_EXTERN void dmplexgetsubpointis_(DM *a, IS *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMPlexGetSubpointIS(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetenclosurerelation_ DMGETENCLOSURERELATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetenclosurerelation_ dmgetenclosurerelation
#endif
PETSC_EXTERN void dmgetenclosurerelation_(DM *a, DM *b, DMEnclosureType *c, PetscErrorCode *ierr)
{
  *ierr = DMGetEnclosureRelation(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetenclosurepoint_ DMGETENCLOSUREPOINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetenclosurepoint_ dmgetenclosurepoint
#endif
PETSC_EXTERN void dmgetenclosurepoint_(DM *a, DM *b, DMEnclosureType *c, PetscInt *d, PetscInt *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(e);
  *ierr = DMGetEnclosurePoint(*a, *b, *c, *d, e);
  if (*ierr) return;
}
