#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscweakformcopy_ PETSCWEAKFORMCOPY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscweakformcopy_ petscweakformcopy
#endif
PETSC_EXTERN void petscweakformcopy_(PetscWeakForm *a, PetscWeakForm *b, PetscErrorCode *ierr)
{
  *ierr = PetscWeakFormCopy(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscweakformclear_ PETSCWEAKFORMCLEAR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscweakformclear_ petscweakformclear
#endif
PETSC_EXTERN void petscweakformclear_(PetscWeakForm *a, PetscErrorCode *ierr)
{
  *ierr = PetscWeakFormClear(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscweakformrewritekeys_ PETSCWEAKFORMREWRITEKEYS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscweakformrewritekeys_ petscweakformrewritekeys
#endif
PETSC_EXTERN void petscweakformrewritekeys_(PetscWeakForm *a, DMLabel *b, PetscInt *c, const PetscInt d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  *ierr = PetscWeakFormRewriteKeys(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscweakformreplacelabel_ PETSCWEAKFORMREPLACELABEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscweakformreplacelabel_ petscweakformreplacelabel
#endif
PETSC_EXTERN void petscweakformreplacelabel_(PetscWeakForm *a, DMLabel *b, PetscErrorCode *ierr)
{
  *ierr = PetscWeakFormReplaceLabel(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscweakformclearindex_ PETSCWEAKFORMCLEARINDEX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscweakformclearindex_ petscweakformclearindex
#endif
PETSC_EXTERN void petscweakformclearindex_(PetscWeakForm *a, DMLabel *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscWeakFormKind *f, PetscInt *g, PetscErrorCode *ierr)
{
  *ierr = PetscWeakFormClearIndex(*a, *b, *c, *d, *e, *f, *g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscweakformhasjacobian_ PETSCWEAKFORMHASJACOBIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscweakformhasjacobian_ petscweakformhasjacobian
#endif
PETSC_EXTERN void petscweakformhasjacobian_(PetscWeakForm *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscWeakFormHasJacobian(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscweakformhasjacobianpreconditioner_ PETSCWEAKFORMHASJACOBIANPRECONDITIONER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscweakformhasjacobianpreconditioner_ petscweakformhasjacobianpreconditioner
#endif
PETSC_EXTERN void petscweakformhasjacobianpreconditioner_(PetscWeakForm *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscWeakFormHasJacobianPreconditioner(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscweakformhasbdjacobian_ PETSCWEAKFORMHASBDJACOBIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscweakformhasbdjacobian_ petscweakformhasbdjacobian
#endif
PETSC_EXTERN void petscweakformhasbdjacobian_(PetscWeakForm *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscWeakFormHasBdJacobian(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscweakformhasbdjacobianpreconditioner_ PETSCWEAKFORMHASBDJACOBIANPRECONDITIONER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscweakformhasbdjacobianpreconditioner_ petscweakformhasbdjacobianpreconditioner
#endif
PETSC_EXTERN void petscweakformhasbdjacobianpreconditioner_(PetscWeakForm *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscWeakFormHasBdJacobianPreconditioner(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscweakformhasdynamicjacobian_ PETSCWEAKFORMHASDYNAMICJACOBIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscweakformhasdynamicjacobian_ petscweakformhasdynamicjacobian
#endif
PETSC_EXTERN void petscweakformhasdynamicjacobian_(PetscWeakForm *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscWeakFormHasDynamicJacobian(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscweakformgetnumfields_ PETSCWEAKFORMGETNUMFIELDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscweakformgetnumfields_ petscweakformgetnumfields
#endif
PETSC_EXTERN void petscweakformgetnumfields_(PetscWeakForm *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscWeakFormGetNumFields(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscweakformsetnumfields_ PETSCWEAKFORMSETNUMFIELDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscweakformsetnumfields_ petscweakformsetnumfields
#endif
PETSC_EXTERN void petscweakformsetnumfields_(PetscWeakForm *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PetscWeakFormSetNumFields(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscweakformdestroy_ PETSCWEAKFORMDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscweakformdestroy_ petscweakformdestroy
#endif
PETSC_EXTERN void petscweakformdestroy_(PetscWeakForm *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscWeakFormDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscweakformview_ PETSCWEAKFORMVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscweakformview_ petscweakformview
#endif
PETSC_EXTERN void petscweakformview_(PetscWeakForm *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = PetscWeakFormView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscweakformcreate_ PETSCWEAKFORMCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscweakformcreate_ petscweakformcreate
#endif
PETSC_EXTERN void petscweakformcreate_(MPI_Fint *a, PetscWeakForm *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscWeakFormCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscds.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscformkeysort_ PETSCFORMKEYSORT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscformkeysort_ petscformkeysort
#endif
PETSC_EXTERN void petscformkeysort_(PetscInt *a, PetscFormKey b[], PetscErrorCode *ierr)
{
  *ierr = PetscFormKeySort(*a, b);
  if (*ierr) return;
}
