#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taoparametersinitialize_ TAOPARAMETERSINITIALIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taoparametersinitialize_ taoparametersinitialize
#endif
PETSC_EXTERN void taoparametersinitialize_(Tao *a, PetscErrorCode *ierr)
{
  *ierr = TaoParametersInitialize(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taocreate_ TAOCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taocreate_ taocreate
#endif
PETSC_EXTERN void taocreate_(MPI_Fint *a, Tao *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = TaoCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taosolve_ TAOSOLVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taosolve_ taosolve
#endif
PETSC_EXTERN void taosolve_(Tao *a, PetscErrorCode *ierr)
{
  *ierr = TaoSolve(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taosetup_ TAOSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taosetup_ taosetup
#endif
PETSC_EXTERN void taosetup_(Tao *a, PetscErrorCode *ierr)
{
  *ierr = TaoSetUp(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taodestroy_ TAODESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taodestroy_ taodestroy
#endif
PETSC_EXTERN void taodestroy_(Tao *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = TaoDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taokspsetuseew_ TAOKSPSETUSEEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taokspsetuseew_ taokspsetuseew
#endif
PETSC_EXTERN void taokspsetuseew_(Tao *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = TaoKSPSetUseEW(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taosetfromoptions_ TAOSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taosetfromoptions_ taosetfromoptions
#endif
PETSC_EXTERN void taosetfromoptions_(Tao *a, PetscErrorCode *ierr)
{
  *ierr = TaoSetFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taoviewfromoptions_ TAOVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taoviewfromoptions_ taoviewfromoptions
#endif
PETSC_EXTERN void taoviewfromoptions_(Tao *a, PetscObject *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = TaoViewFromOptions(*a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taoview_ TAOVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taoview_ taoview
#endif
PETSC_EXTERN void taoview_(Tao *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = TaoView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taosetrecyclehistory_ TAOSETRECYCLEHISTORY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taosetrecyclehistory_ taosetrecyclehistory
#endif
PETSC_EXTERN void taosetrecyclehistory_(Tao *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = TaoSetRecycleHistory(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taogetrecyclehistory_ TAOGETRECYCLEHISTORY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taogetrecyclehistory_ taogetrecyclehistory
#endif
PETSC_EXTERN void taogetrecyclehistory_(Tao *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = TaoGetRecycleHistory(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taosettolerances_ TAOSETTOLERANCES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taosettolerances_ taosettolerances
#endif
PETSC_EXTERN void taosettolerances_(Tao *a, PetscReal *b, PetscReal *c, PetscReal *d, PetscErrorCode *ierr)
{
  *ierr = TaoSetTolerances(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taosetconstrainttolerances_ TAOSETCONSTRAINTTOLERANCES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taosetconstrainttolerances_ taosetconstrainttolerances
#endif
PETSC_EXTERN void taosetconstrainttolerances_(Tao *a, PetscReal *b, PetscReal *c, PetscErrorCode *ierr)
{
  *ierr = TaoSetConstraintTolerances(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taogetconstrainttolerances_ TAOGETCONSTRAINTTOLERANCES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taogetconstrainttolerances_ taogetconstrainttolerances
#endif
PETSC_EXTERN void taogetconstrainttolerances_(Tao *a, PetscReal *b, PetscReal *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  *ierr = TaoGetConstraintTolerances(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taosetfunctionlowerbound_ TAOSETFUNCTIONLOWERBOUND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taosetfunctionlowerbound_ taosetfunctionlowerbound
#endif
PETSC_EXTERN void taosetfunctionlowerbound_(Tao *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = TaoSetFunctionLowerBound(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taogetfunctionlowerbound_ TAOGETFUNCTIONLOWERBOUND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taogetfunctionlowerbound_ taogetfunctionlowerbound
#endif
PETSC_EXTERN void taogetfunctionlowerbound_(Tao *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = TaoGetFunctionLowerBound(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taosetmaximumfunctionevaluations_ TAOSETMAXIMUMFUNCTIONEVALUATIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taosetmaximumfunctionevaluations_ taosetmaximumfunctionevaluations
#endif
PETSC_EXTERN void taosetmaximumfunctionevaluations_(Tao *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = TaoSetMaximumFunctionEvaluations(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taogetmaximumfunctionevaluations_ TAOGETMAXIMUMFUNCTIONEVALUATIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taogetmaximumfunctionevaluations_ taogetmaximumfunctionevaluations
#endif
PETSC_EXTERN void taogetmaximumfunctionevaluations_(Tao *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = TaoGetMaximumFunctionEvaluations(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taogetcurrentfunctionevaluations_ TAOGETCURRENTFUNCTIONEVALUATIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taogetcurrentfunctionevaluations_ taogetcurrentfunctionevaluations
#endif
PETSC_EXTERN void taogetcurrentfunctionevaluations_(Tao *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = TaoGetCurrentFunctionEvaluations(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taosetmaximumiterations_ TAOSETMAXIMUMITERATIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taosetmaximumiterations_ taosetmaximumiterations
#endif
PETSC_EXTERN void taosetmaximumiterations_(Tao *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = TaoSetMaximumIterations(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taogetmaximumiterations_ TAOGETMAXIMUMITERATIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taogetmaximumiterations_ taogetmaximumiterations
#endif
PETSC_EXTERN void taogetmaximumiterations_(Tao *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = TaoGetMaximumIterations(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taosetinitialtrustregionradius_ TAOSETINITIALTRUSTREGIONRADIUS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taosetinitialtrustregionradius_ taosetinitialtrustregionradius
#endif
PETSC_EXTERN void taosetinitialtrustregionradius_(Tao *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = TaoSetInitialTrustRegionRadius(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taogetinitialtrustregionradius_ TAOGETINITIALTRUSTREGIONRADIUS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taogetinitialtrustregionradius_ taogetinitialtrustregionradius
#endif
PETSC_EXTERN void taogetinitialtrustregionradius_(Tao *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = TaoGetInitialTrustRegionRadius(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taogetcurrenttrustregionradius_ TAOGETCURRENTTRUSTREGIONRADIUS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taogetcurrenttrustregionradius_ taogetcurrenttrustregionradius
#endif
PETSC_EXTERN void taogetcurrenttrustregionradius_(Tao *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = TaoGetCurrentTrustRegionRadius(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taogettolerances_ TAOGETTOLERANCES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taogettolerances_ taogettolerances
#endif
PETSC_EXTERN void taogettolerances_(Tao *a, PetscReal *b, PetscReal *c, PetscReal *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(d);
  *ierr = TaoGetTolerances(*a, b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taogetksp_ TAOGETKSP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taogetksp_ taogetksp
#endif
PETSC_EXTERN void taogetksp_(Tao *a, KSP *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = TaoGetKSP(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taogetlinearsolveiterations_ TAOGETLINEARSOLVEITERATIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taogetlinearsolveiterations_ taogetlinearsolveiterations
#endif
PETSC_EXTERN void taogetlinearsolveiterations_(Tao *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = TaoGetLinearSolveIterations(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taogetlinesearch_ TAOGETLINESEARCH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taogetlinesearch_ taogetlinesearch
#endif
PETSC_EXTERN void taogetlinesearch_(Tao *a, TaoLineSearch *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = TaoGetLineSearch(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taoaddlinesearchcounts_ TAOADDLINESEARCHCOUNTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taoaddlinesearchcounts_ taoaddlinesearchcounts
#endif
PETSC_EXTERN void taoaddlinesearchcounts_(Tao *a, PetscErrorCode *ierr)
{
  *ierr = TaoAddLineSearchCounts(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taogetsolution_ TAOGETSOLUTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taogetsolution_ taogetsolution
#endif
PETSC_EXTERN void taogetsolution_(Tao *a, Vec *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = TaoGetSolution(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taoresetstatistics_ TAORESETSTATISTICS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taoresetstatistics_ taoresetstatistics
#endif
PETSC_EXTERN void taoresetstatistics_(Tao *a, PetscErrorCode *ierr)
{
  *ierr = TaoResetStatistics(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taomonitorcancel_ TAOMONITORCANCEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taomonitorcancel_ taomonitorcancel
#endif
PETSC_EXTERN void taomonitorcancel_(Tao *a, PetscErrorCode *ierr)
{
  *ierr = TaoMonitorCancel(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taomonitordefault_ TAOMONITORDEFAULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taomonitordefault_ taomonitordefault
#endif
PETSC_EXTERN void taomonitordefault_(Tao *a, void *b, PetscErrorCode *ierr)
{
  *ierr = TaoMonitorDefault(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taomonitorglobalization_ TAOMONITORGLOBALIZATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taomonitorglobalization_ taomonitorglobalization
#endif
PETSC_EXTERN void taomonitorglobalization_(Tao *a, void *b, PetscErrorCode *ierr)
{
  *ierr = TaoMonitorGlobalization(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taomonitordefaultshort_ TAOMONITORDEFAULTSHORT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taomonitordefaultshort_ taomonitordefaultshort
#endif
PETSC_EXTERN void taomonitordefaultshort_(Tao *a, void *b, PetscErrorCode *ierr)
{
  *ierr = TaoMonitorDefaultShort(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taomonitorconstraintnorm_ TAOMONITORCONSTRAINTNORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taomonitorconstraintnorm_ taomonitorconstraintnorm
#endif
PETSC_EXTERN void taomonitorconstraintnorm_(Tao *a, void *b, PetscErrorCode *ierr)
{
  *ierr = TaoMonitorConstraintNorm(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taomonitorsolution_ TAOMONITORSOLUTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taomonitorsolution_ taomonitorsolution
#endif
PETSC_EXTERN void taomonitorsolution_(Tao *a, void *b, PetscErrorCode *ierr)
{
  *ierr = TaoMonitorSolution(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taomonitorgradient_ TAOMONITORGRADIENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taomonitorgradient_ taomonitorgradient
#endif
PETSC_EXTERN void taomonitorgradient_(Tao *a, void *b, PetscErrorCode *ierr)
{
  *ierr = TaoMonitorGradient(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taomonitorstep_ TAOMONITORSTEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taomonitorstep_ taomonitorstep
#endif
PETSC_EXTERN void taomonitorstep_(Tao *a, void *b, PetscErrorCode *ierr)
{
  *ierr = TaoMonitorStep(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taomonitorsolutiondraw_ TAOMONITORSOLUTIONDRAW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taomonitorsolutiondraw_ taomonitorsolutiondraw
#endif
PETSC_EXTERN void taomonitorsolutiondraw_(Tao *a, void *b, PetscErrorCode *ierr)
{
  *ierr = TaoMonitorSolutionDraw(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taomonitorgradientdraw_ TAOMONITORGRADIENTDRAW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taomonitorgradientdraw_ taomonitorgradientdraw
#endif
PETSC_EXTERN void taomonitorgradientdraw_(Tao *a, void *b, PetscErrorCode *ierr)
{
  *ierr = TaoMonitorGradientDraw(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taomonitorstepdraw_ TAOMONITORSTEPDRAW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taomonitorstepdraw_ taomonitorstepdraw
#endif
PETSC_EXTERN void taomonitorstepdraw_(Tao *a, void *b, PetscErrorCode *ierr)
{
  *ierr = TaoMonitorStepDraw(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taomonitorresidual_ TAOMONITORRESIDUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taomonitorresidual_ taomonitorresidual
#endif
PETSC_EXTERN void taomonitorresidual_(Tao *a, void *b, PetscErrorCode *ierr)
{
  *ierr = TaoMonitorResidual(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taodefaultconvergencetest_ TAODEFAULTCONVERGENCETEST
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taodefaultconvergencetest_ taodefaultconvergencetest
#endif
PETSC_EXTERN void taodefaultconvergencetest_(Tao *a, void *b, PetscErrorCode *ierr)
{
  *ierr = TaoDefaultConvergenceTest(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taosetoptionsprefix_ TAOSETOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taosetoptionsprefix_ taosetoptionsprefix
#endif
PETSC_EXTERN void taosetoptionsprefix_(Tao *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = TaoSetOptionsPrefix(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taoappendoptionsprefix_ TAOAPPENDOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taoappendoptionsprefix_ taoappendoptionsprefix
#endif
PETSC_EXTERN void taoappendoptionsprefix_(Tao *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = TaoAppendOptionsPrefix(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taogetoptionsprefix_ TAOGETOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taogetoptionsprefix_ taogetoptionsprefix
#endif
PETSC_EXTERN void taogetoptionsprefix_(Tao *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = TaoGetOptionsPrefix(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taosettype_ TAOSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taosettype_ taosettype
#endif
PETSC_EXTERN void taosettype_(Tao *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = TaoSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taoregisterdestroy_ TAOREGISTERDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taoregisterdestroy_ taoregisterdestroy
#endif
PETSC_EXTERN void taoregisterdestroy_(PetscErrorCode *ierr)
{
  *ierr = TaoRegisterDestroy();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taogetiterationnumber_ TAOGETITERATIONNUMBER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taogetiterationnumber_ taogetiterationnumber
#endif
PETSC_EXTERN void taogetiterationnumber_(Tao *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = TaoGetIterationNumber(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taogetresidualnorm_ TAOGETRESIDUALNORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taogetresidualnorm_ taogetresidualnorm
#endif
PETSC_EXTERN void taogetresidualnorm_(Tao *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = TaoGetResidualNorm(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taosetiterationnumber_ TAOSETITERATIONNUMBER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taosetiterationnumber_ taosetiterationnumber
#endif
PETSC_EXTERN void taosetiterationnumber_(Tao *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = TaoSetIterationNumber(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taogettotaliterationnumber_ TAOGETTOTALITERATIONNUMBER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taogettotaliterationnumber_ taogettotaliterationnumber
#endif
PETSC_EXTERN void taogettotaliterationnumber_(Tao *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = TaoGetTotalIterationNumber(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taosettotaliterationnumber_ TAOSETTOTALITERATIONNUMBER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taosettotaliterationnumber_ taosettotaliterationnumber
#endif
PETSC_EXTERN void taosettotaliterationnumber_(Tao *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = TaoSetTotalIterationNumber(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taosetconvergedreason_ TAOSETCONVERGEDREASON
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taosetconvergedreason_ taosetconvergedreason
#endif
PETSC_EXTERN void taosetconvergedreason_(Tao *a, TaoConvergedReason *b, PetscErrorCode *ierr)
{
  *ierr = TaoSetConvergedReason(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taogetconvergedreason_ TAOGETCONVERGEDREASON
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taogetconvergedreason_ taogetconvergedreason
#endif
PETSC_EXTERN void taogetconvergedreason_(Tao *a, TaoConvergedReason *b, PetscErrorCode *ierr)
{
  *ierr = TaoGetConvergedReason(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taogetsolutionstatus_ TAOGETSOLUTIONSTATUS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taogetsolutionstatus_ taogetsolutionstatus
#endif
PETSC_EXTERN void taogetsolutionstatus_(Tao *a, PetscInt *b, PetscReal *c, PetscReal *d, PetscReal *e, PetscReal *f, TaoConvergedReason *g, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLREAL(e);
  CHKFORTRANNULLREAL(f);
  *ierr = TaoGetSolutionStatus(*a, b, c, d, e, f, g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taogettype_ TAOGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taogettype_ taogettype
#endif
PETSC_EXTERN void taogettype_(Tao *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = TaoGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taomonitor_ TAOMONITOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taomonitor_ taomonitor
#endif
PETSC_EXTERN void taomonitor_(Tao *a, PetscInt *b, PetscReal *c, PetscReal *d, PetscReal *e, PetscReal *f, PetscErrorCode *ierr)
{
  *ierr = TaoMonitor(*a, *b, *c, *d, *e, *f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taosetconvergencehistory_ TAOSETCONVERGENCEHISTORY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taosetconvergencehistory_ taosetconvergencehistory
#endif
PETSC_EXTERN void taosetconvergencehistory_(Tao *a, PetscReal b[], PetscReal c[], PetscReal d[], PetscInt e[], PetscInt *f, PetscBool *g, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLINTEGER(e);
  *ierr = TaoSetConvergenceHistory(*a, b, c, d, e, *f, *g ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taosetapplicationcontext_ TAOSETAPPLICATIONCONTEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taosetapplicationcontext_ taosetapplicationcontext
#endif
PETSC_EXTERN void taosetapplicationcontext_(Tao *a, void *b, PetscErrorCode *ierr)
{
  *ierr = TaoSetApplicationContext(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taogetapplicationcontext_ TAOGETAPPLICATIONCONTEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taogetapplicationcontext_ taogetapplicationcontext
#endif
PETSC_EXTERN void taogetapplicationcontext_(Tao *a, PeCtx b, PetscErrorCode *ierr)
{
  *ierr = TaoGetApplicationContext(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taosetgradientnorm_ TAOSETGRADIENTNORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taosetgradientnorm_ taosetgradientnorm
#endif
PETSC_EXTERN void taosetgradientnorm_(Tao *a, Mat *b, PetscErrorCode *ierr)
{
  *ierr = TaoSetGradientNorm(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taogetgradientnorm_ TAOGETGRADIENTNORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taogetgradientnorm_ taogetgradientnorm
#endif
PETSC_EXTERN void taogetgradientnorm_(Tao *a, Mat *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = TaoGetGradientNorm(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taogradientnorm_ TAOGRADIENTNORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taogradientnorm_ taogradientnorm
#endif
PETSC_EXTERN void taogradientnorm_(Tao *a, Vec *b, NormType *c, PetscReal *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(d);
  *ierr = TaoGradientNorm(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taomonitordrawctxcreate_ TAOMONITORDRAWCTXCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taomonitordrawctxcreate_ taomonitordrawctxcreate
#endif
PETSC_EXTERN void taomonitordrawctxcreate_(MPI_Fint *a, char b[], char c[], int *d, int *e, int *f, int *g, PetscInt *h, TaoMonitorDrawCtx *i, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  PetscBool null_i = !*(void**) i ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(i);
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  CHKFORTRANNULLOBJECT(i);
  *ierr = TaoMonitorDrawCtxCreate(MPI_Comm_f2c(*(a)), c_b, c_c, *d, *e, *f, *g, *h, i);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
  if (! null_i && !*(void**) i) *(void **) i = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taomonitordrawctxdestroy_ TAOMONITORDRAWCTXDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taomonitordrawctxdestroy_ taomonitordrawctxdestroy
#endif
PETSC_EXTERN void taomonitordrawctxdestroy_(TaoMonitorDrawCtx *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = TaoMonitorDrawCtxDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
