#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcredundantsetnumber_ PCREDUNDANTSETNUMBER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcredundantsetnumber_ pcredundantsetnumber
#endif
PETSC_EXTERN void pcredundantsetnumber_(PC *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PCRedundantSetNumber(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcredundantsetscatter_ PCREDUNDANTSETSCATTER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcredundantsetscatter_ pcredundantsetscatter
#endif
PETSC_EXTERN void pcredundantsetscatter_(PC *a, VecScatter *b, VecScatter *c, PetscErrorCode *ierr)
{
  *ierr = PCRedundantSetScatter(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcredundantgetksp_ PCREDUNDANTGETKSP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcredundantgetksp_ pcredundantgetksp
#endif
PETSC_EXTERN void pcredundantgetksp_(PC *a, KSP *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PCRedundantGetKSP(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcredundantgetoperators_ PCREDUNDANTGETOPERATORS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcredundantgetoperators_ pcredundantgetoperators
#endif
PETSC_EXTERN void pcredundantgetoperators_(PC *a, Mat *b, Mat *c, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = PCRedundantGetOperators(*a, b, c);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
