#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscobjectviewsaws_ PETSCOBJECTVIEWSAWS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscobjectviewsaws_ petscobjectviewsaws
#endif
PETSC_EXTERN void petscobjectviewsaws_(PetscObject *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = PetscObjectViewSAWs(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewersaws.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewersawsopen_ PETSCVIEWERSAWSOPEN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewersawsopen_ petscviewersawsopen
#endif
PETSC_EXTERN void petscviewersawsopen_(MPI_Fint *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscViewerSAWsOpen(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
