#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgasmsettotalsubdomains_ PCGASMSETTOTALSUBDOMAINS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgasmsettotalsubdomains_ pcgasmsettotalsubdomains
#endif
PETSC_EXTERN void pcgasmsettotalsubdomains_(PC *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PCGASMSetTotalSubdomains(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgasmsetsubdomains_ PCGASMSETSUBDOMAINS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgasmsetsubdomains_ pcgasmsetsubdomains
#endif
PETSC_EXTERN void pcgasmsetsubdomains_(PC *a, PetscInt *b, IS c[], IS d[], PetscErrorCode *ierr)
{
  *ierr = PCGASMSetSubdomains(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgasmsetoverlap_ PCGASMSETOVERLAP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgasmsetoverlap_ pcgasmsetoverlap
#endif
PETSC_EXTERN void pcgasmsetoverlap_(PC *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PCGASMSetOverlap(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgasmsettype_ PCGASMSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgasmsettype_ pcgasmsettype
#endif
PETSC_EXTERN void pcgasmsettype_(PC *a, PCGASMType *b, PetscErrorCode *ierr)
{
  *ierr = PCGASMSetType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgasmsetsortindices_ PCGASMSETSORTINDICES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgasmsetsortindices_ pcgasmsetsortindices
#endif
PETSC_EXTERN void pcgasmsetsortindices_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCGASMSetSortIndices(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgasmsetusedmsubdomains_ PCGASMSETUSEDMSUBDOMAINS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgasmsetusedmsubdomains_ pcgasmsetusedmsubdomains
#endif
PETSC_EXTERN void pcgasmsetusedmsubdomains_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCGASMSetUseDMSubdomains(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcgasmgetusedmsubdomains_ PCGASMGETUSEDMSUBDOMAINS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcgasmgetusedmsubdomains_ pcgasmgetusedmsubdomains
#endif
PETSC_EXTERN void pcgasmgetusedmsubdomains_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PCGASMGetUseDMSubdomains(*a, b);
  if (*ierr) return;
}
