#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabsetblockfills_ DMMOABSETBLOCKFILLS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabsetblockfills_ dmmoabsetblockfills
#endif
PETSC_EXTERN void dmmoabsetblockfills_(DM *a, const PetscInt *b, const PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMMoabSetBlockFills(*a, b, c);
  if (*ierr) return;
}
