#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsortintwithpermutation_ PETSCSORTINTWITHPERMUTATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsortintwithpermutation_ petscsortintwithpermutation
#endif
PETSC_EXTERN void petscsortintwithpermutation_(PetscInt *a, const PetscInt b[], PetscInt c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscSortIntWithPermutation(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsortrealwithpermutation_ PETSCSORTREALWITHPERMUTATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsortrealwithpermutation_ petscsortrealwithpermutation
#endif
PETSC_EXTERN void petscsortrealwithpermutation_(PetscInt *a, const PetscReal b[], PetscInt c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscSortRealWithPermutation(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsortstrwithpermutation_ PETSCSORTSTRWITHPERMUTATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsortstrwithpermutation_ petscsortstrwithpermutation
#endif
PETSC_EXTERN void petscsortstrwithpermutation_(PetscInt *a, char b[], PetscInt c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  CHKFORTRANNULLINTEGER(c);
  *ierr = PetscSortStrWithPermutation(*a, (const char **)&c_b, c);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
