#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgllesettype_ TSGLLESETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgllesettype_ tsgllesettype
#endif
PETSC_EXTERN void tsgllesettype_(TS *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = TSGLLESetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgllesetaccepttype_ TSGLLESETACCEPTTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgllesetaccepttype_ tsgllesetaccepttype
#endif
PETSC_EXTERN void tsgllesetaccepttype_(TS *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = TSGLLESetAcceptType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgllegetadapt_ TSGLLEGETADAPT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgllegetadapt_ tsgllegetadapt
#endif
PETSC_EXTERN void tsgllegetadapt_(TS *a, TSGLLEAdapt *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = TSGLLEGetAdapt(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsglleinitializepackage_ TSGLLEINITIALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsglleinitializepackage_ tsglleinitializepackage
#endif
PETSC_EXTERN void tsglleinitializepackage_(PetscErrorCode *ierr)
{
  *ierr = TSGLLEInitializePackage();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsgllefinalizepackage_ TSGLLEFINALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsgllefinalizepackage_ tsgllefinalizepackage
#endif
PETSC_EXTERN void tsgllefinalizepackage_(PetscErrorCode *ierr)
{
  *ierr = TSGLLEFinalizePackage();
  if (*ierr) return;
}
