#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmproduct.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmproductgetdm_ DMPRODUCTGETDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmproductgetdm_ dmproductgetdm
#endif
PETSC_EXTERN void dmproductgetdm_(DM *a, PetscInt *b, DM *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMProductGetDM(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmproduct.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmproductsetdm_ DMPRODUCTSETDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmproductsetdm_ dmproductsetdm
#endif
PETSC_EXTERN void dmproductsetdm_(DM *a, PetscInt *b, DM *c, PetscErrorCode *ierr)
{
  *ierr = DMProductSetDM(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmproduct.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmproductsetdimensionindex_ DMPRODUCTSETDIMENSIONINDEX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmproductsetdimensionindex_ dmproductsetdimensionindex
#endif
PETSC_EXTERN void dmproductsetdimensionindex_(DM *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  *ierr = DMProductSetDimensionIndex(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmproduct.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmproductgetdimensionindex_ DMPRODUCTGETDIMENSIONINDEX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmproductgetdimensionindex_ dmproductgetdimensionindex
#endif
PETSC_EXTERN void dmproductgetdimensionindex_(DM *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMProductGetDimensionIndex(*a, *b, c);
  if (*ierr) return;
}
