#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taosetsolution_ TAOSETSOLUTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taosetsolution_ taosetsolution
#endif
PETSC_EXTERN void taosetsolution_(Tao *a, Vec *b, PetscErrorCode *ierr)
{
  *ierr = TaoSetSolution(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taotestgradient_ TAOTESTGRADIENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taotestgradient_ taotestgradient
#endif
PETSC_EXTERN void taotestgradient_(Tao *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = TaoTestGradient(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taocomputegradient_ TAOCOMPUTEGRADIENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taocomputegradient_ taocomputegradient
#endif
PETSC_EXTERN void taocomputegradient_(Tao *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = TaoComputeGradient(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taocomputeobjective_ TAOCOMPUTEOBJECTIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taocomputeobjective_ taocomputeobjective
#endif
PETSC_EXTERN void taocomputeobjective_(Tao *a, Vec *b, PetscReal *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  *ierr = TaoComputeObjective(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taocomputeobjectiveandgradient_ TAOCOMPUTEOBJECTIVEANDGRADIENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taocomputeobjectiveandgradient_ taocomputeobjectiveandgradient
#endif
PETSC_EXTERN void taocomputeobjectiveandgradient_(Tao *a, Vec *b, PetscReal *c, Vec *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  *ierr = TaoComputeObjectiveAndGradient(*a, *b, c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taosetresidualweights_ TAOSETRESIDUALWEIGHTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taosetresidualweights_ taosetresidualweights
#endif
PETSC_EXTERN void taosetresidualweights_(Tao *a, Vec *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscReal *f, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLREAL(f);
  *ierr = TaoSetResidualWeights(*a, *b, *c, d, e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taocomputeresidual_ TAOCOMPUTERESIDUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taocomputeresidual_ taocomputeresidual
#endif
PETSC_EXTERN void taocomputeresidual_(Tao *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = TaoComputeResidual(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taoisobjectivedefined_ TAOISOBJECTIVEDEFINED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taoisobjectivedefined_ taoisobjectivedefined
#endif
PETSC_EXTERN void taoisobjectivedefined_(Tao *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = TaoIsObjectiveDefined(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taoisgradientdefined_ TAOISGRADIENTDEFINED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taoisgradientdefined_ taoisgradientdefined
#endif
PETSC_EXTERN void taoisgradientdefined_(Tao *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = TaoIsGradientDefined(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taoisobjectiveandgradientdefined_ TAOISOBJECTIVEANDGRADIENTDEFINED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taoisobjectiveandgradientdefined_ taoisobjectiveandgradientdefined
#endif
PETSC_EXTERN void taoisobjectiveandgradientdefined_(Tao *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = TaoIsObjectiveAndGradientDefined(*a, b);
  if (*ierr) return;
}
