#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matshellgetcontext_ MATSHELLGETCONTEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matshellgetcontext_ matshellgetcontext
#endif
PETSC_EXTERN void matshellgetcontext_(Mat *a, void *b, PetscErrorCode *ierr)
{
  *ierr = MatShellGetContext(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreateshell_ MATCREATESHELL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreateshell_ matcreateshell
#endif
PETSC_EXTERN void matcreateshell_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, void *f, Mat *g, PetscErrorCode *ierr)
{
  PetscBool null_g = !*(void**) g ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(g);
  *ierr = MatCreateShell(MPI_Comm_f2c(*(a)), *b, *c, *d, *e, f, g);
  if (*ierr) return;
  if (! null_g && !*(void**) g) *(void **) g = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matshellsetcontext_ MATSHELLSETCONTEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matshellsetcontext_ matshellsetcontext
#endif
PETSC_EXTERN void matshellsetcontext_(Mat *a, void *b, PetscErrorCode *ierr)
{
  *ierr = MatShellSetContext(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matshellsetvectype_ MATSHELLSETVECTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matshellsetvectype_ matshellsetvectype
#endif
PETSC_EXTERN void matshellsetvectype_(Mat *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = MatShellSetVecType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matshellsetmanagescalingshifts_ MATSHELLSETMANAGESCALINGSHIFTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matshellsetmanagescalingshifts_ matshellsetmanagescalingshifts
#endif
PETSC_EXTERN void matshellsetmanagescalingshifts_(Mat *a, PetscErrorCode *ierr)
{
  *ierr = MatShellSetManageScalingShifts(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matisshell_ MATISSHELL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matisshell_ matisshell
#endif
PETSC_EXTERN void matisshell_(Mat *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = MatIsShell(*a, b);
  if (*ierr) return;
}
