#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscspacecreatesubspace_ PETSCSPACECREATESUBSPACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscspacecreatesubspace_ petscspacecreatesubspace
#endif
PETSC_EXTERN void petscspacecreatesubspace_(PetscSpace *a, PetscDualSpace *b, PetscReal *c, PetscReal *d, PetscReal *e, PetscReal *f, PetscCopyMode *g, PetscSpace *h, PetscErrorCode *ierr)
{
  PetscBool null_h = !*(void**) h ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLREAL(e);
  CHKFORTRANNULLREAL(f);
  CHKFORTRANNULLOBJECT(h);
  *ierr = PetscSpaceCreateSubspace(*a, *b, c, d, e, f, *g, h);
  if (*ierr) return;
  if (! null_h && !*(void**) h) *(void **) h = (void *)-2;
}
