#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscrandomgetvalue_ PETSCRANDOMGETVALUE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscrandomgetvalue_ petscrandomgetvalue
#endif
PETSC_EXTERN void petscrandomgetvalue_(PetscRandom *a, PetscScalar *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(b);
  *ierr = PetscRandomGetValue(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscrandomgetvaluereal_ PETSCRANDOMGETVALUEREAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscrandomgetvaluereal_ petscrandomgetvaluereal
#endif
PETSC_EXTERN void petscrandomgetvaluereal_(PetscRandom *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = PetscRandomGetValueReal(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscrandomgetvalues_ PETSCRANDOMGETVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscrandomgetvalues_ petscrandomgetvalues
#endif
PETSC_EXTERN void petscrandomgetvalues_(PetscRandom *a, PetscInt *b, PetscScalar *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(c);
  *ierr = PetscRandomGetValues(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscrandomgetvaluesreal_ PETSCRANDOMGETVALUESREAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscrandomgetvaluesreal_ petscrandomgetvaluesreal
#endif
PETSC_EXTERN void petscrandomgetvaluesreal_(PetscRandom *a, PetscInt *b, PetscReal *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  *ierr = PetscRandomGetValuesReal(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscrandomgetinterval_ PETSCRANDOMGETINTERVAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscrandomgetinterval_ petscrandomgetinterval
#endif
PETSC_EXTERN void petscrandomgetinterval_(PetscRandom *a, PetscScalar *b, PetscScalar *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(b);
  CHKFORTRANNULLSCALAR(c);
  *ierr = PetscRandomGetInterval(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscrandomsetinterval_ PETSCRANDOMSETINTERVAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscrandomsetinterval_ petscrandomsetinterval
#endif
PETSC_EXTERN void petscrandomsetinterval_(PetscRandom *a, PetscScalar *b, PetscScalar *c, PetscErrorCode *ierr)
{
  *ierr = PetscRandomSetInterval(*a, *b, *c);
  if (*ierr) return;
}
