#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscvieweradiosopen_ PETSCVIEWERADIOSOPEN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscvieweradiosopen_ petscvieweradiosopen
#endif
PETSC_EXTERN void petscvieweradiosopen_(MPI_Fint *a, char b[], PetscFileMode *c, PetscViewer *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(d);
  *ierr = PetscViewerADIOSOpen(MPI_Comm_f2c(*(a)), c_b, *c, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
