  type, extends(tPetscObject) ::  tPetscDualSpace
  end type tPetscDualSpace
  PetscDualSpace, parameter :: PETSC_NULL_DUALSPACE = tPetscDualSpace(0)
  PetscDualSpace, target :: PETSC_NULL_DUALSPACE_ARRAY(1) = [tPetscDualSpace(0)]
  PetscDualSpace, pointer :: PETSC_NULL_DUALSPACE_POINTER(:) => PETSC_NULL_DUALSPACE_ARRAY
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_DUALSPACE
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_DUALSPACE_ARRAY
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_DUALSPACE_POINTER
#endif

  type ePetscDualSpaceReferenceCell
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type ePetscDualSpaceReferenceCell

  PetscDualSpaceReferenceCell, parameter :: PETSC_NULL_DUALSPACEREFERENCECELL = ePetscDualSpaceReferenceCell(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_DUALSPACEREFERENCECELL
#endif
    PetscDualSpaceReferenceCell, parameter :: PETSCDUALSPACE_REFCELL_SIMPLEX = ePetscDualSpaceReferenceCell(0)
    PetscDualSpaceReferenceCell, parameter :: PETSCDUALSPACE_REFCELL_TENSOR = ePetscDualSpaceReferenceCell(1)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSCDUALSPACE_REFCELL_SIMPLEX
!DEC$ ATTRIBUTES DLLEXPORT::PETSCDUALSPACE_REFCELL_TENSOR
#endif

  type ePetscDualSpaceTransformType
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type ePetscDualSpaceTransformType

  PetscDualSpaceTransformType, parameter :: PETSC_NULL_DUALSPACETRANSFORMTYPE = ePetscDualSpaceTransformType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_DUALSPACETRANSFORMTYPE
#endif
    PetscDualSpaceTransformType, parameter :: IDENTITY_TRANSFORM = ePetscDualSpaceTransformType(0)
    PetscDualSpaceTransformType, parameter :: COVARIANT_PIOLA_TRANSFORM = ePetscDualSpaceTransformType(1)
    PetscDualSpaceTransformType, parameter :: CONTRAVARIANT_PIOLA_TRANSFORM = ePetscDualSpaceTransformType(2)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::IDENTITY_TRANSFORM
!DEC$ ATTRIBUTES DLLEXPORT::COVARIANT_PIOLA_TRANSFORM
!DEC$ ATTRIBUTES DLLEXPORT::CONTRAVARIANT_PIOLA_TRANSFORM
#endif

  CHARACTER(LEN=*), PARAMETER :: PETSCDUALSPACELAGRANGE = 'lagrange'
  CHARACTER(LEN=*), PARAMETER :: PETSCDUALSPACESIMPLE = 'simple'
  CHARACTER(LEN=*), PARAMETER :: PETSCDUALSPACEREFINED = 'refined'
  CHARACTER(LEN=*), PARAMETER :: PETSCDUALSPACEBDM = 'bdm'
  CHARACTER(LEN=*), PARAMETER :: PETSCDUALSPACESUM = 'sum'

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSCDUALSPACELAGRANGE
!DEC$ ATTRIBUTES DLLEXPORT::PETSCDUALSPACESIMPLE
!DEC$ ATTRIBUTES DLLEXPORT::PETSCDUALSPACEREFINED
!DEC$ ATTRIBUTES DLLEXPORT::PETSCDUALSPACEBDM
!DEC$ ATTRIBUTES DLLEXPORT::PETSCDUALSPACESUM
#endif

