#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdagetghostcorners_ DMDAGETGHOSTCORNERS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdagetghostcorners_ dmdagetghostcorners
#endif
PETSC_EXTERN void dmdagetghostcorners_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscInt *f, PetscInt *g, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLINTEGER(f);
  CHKFORTRANNULLINTEGER(g);
  *ierr = DMDAGetGhostCorners(*a, b, c, d, e, f, g);
  if (*ierr) return;
}
