#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabsetfieldvector_ DMMOABSETFIELDVECTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabsetfieldvector_ dmmoabsetfieldvector
#endif
PETSC_EXTERN void dmmoabsetfieldvector_(DM *a, PetscInt *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = DMMoabSetFieldVector(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabsetglobalfieldvector_ DMMOABSETGLOBALFIELDVECTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabsetglobalfieldvector_ dmmoabsetglobalfieldvector
#endif
PETSC_EXTERN void dmmoabsetglobalfieldvector_(DM *a, Vec *b, PetscErrorCode *ierr)
{
  *ierr = DMMoabSetGlobalFieldVector(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabsetfieldnames_ DMMOABSETFIELDNAMES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabsetfieldnames_ dmmoabsetfieldnames
#endif
PETSC_EXTERN void dmmoabsetfieldnames_(DM *a, PetscInt *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c = PETSC_NULLPTR;
  *ierr = DMMoabSetFieldNames(*a, *b, (const char **)&c_c);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)c, c_c, l_c);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, c, l_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabgetfieldname_ DMMOABGETFIELDNAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabgetfieldname_ dmmoabgetfieldname
#endif
PETSC_EXTERN void dmmoabgetfieldname_(DM *a, PetscInt *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c = PETSC_NULLPTR;
  *ierr = DMMoabGetFieldName(*a, *b, (const char **)&c_c);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)c, c_c, l_c);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, c, l_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabsetfieldname_ DMMOABSETFIELDNAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabsetfieldname_ dmmoabsetfieldname
#endif
PETSC_EXTERN void dmmoabsetfieldname_(DM *a, PetscInt *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = DMMoabSetFieldName(*a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabgetfielddof_ DMMOABGETFIELDDOF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabgetfielddof_ dmmoabgetfielddof
#endif
PETSC_EXTERN void dmmoabgetfielddof_(DM *a, moab::EntityHandle *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMMoabGetFieldDof(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabgetfielddofs_ DMMOABGETFIELDDOFS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabgetfielddofs_ dmmoabgetfielddofs
#endif
PETSC_EXTERN void dmmoabgetfielddofs_(DM *a, PetscInt *b, const moab::EntityHandle *c, PetscInt *d, PetscInt *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(e);
  *ierr = DMMoabGetFieldDofs(*a, *b, c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabgetfielddofslocal_ DMMOABGETFIELDDOFSLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabgetfielddofslocal_ dmmoabgetfielddofslocal
#endif
PETSC_EXTERN void dmmoabgetfielddofslocal_(DM *a, PetscInt *b, const moab::EntityHandle *c, PetscInt *d, PetscInt *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(e);
  *ierr = DMMoabGetFieldDofsLocal(*a, *b, c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabgetdofs_ DMMOABGETDOFS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabgetdofs_ dmmoabgetdofs
#endif
PETSC_EXTERN void dmmoabgetdofs_(DM *a, PetscInt *b, const moab::EntityHandle *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMMoabGetDofs(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabgetdofslocal_ DMMOABGETDOFSLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabgetdofslocal_ dmmoabgetdofslocal
#endif
PETSC_EXTERN void dmmoabgetdofslocal_(DM *a, PetscInt *b, const moab::EntityHandle *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMMoabGetDofsLocal(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabgetdofsblocked_ DMMOABGETDOFSBLOCKED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabgetdofsblocked_ dmmoabgetdofsblocked
#endif
PETSC_EXTERN void dmmoabgetdofsblocked_(DM *a, PetscInt *b, const moab::EntityHandle *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMMoabGetDofsBlocked(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabgetdofsblockedlocal_ DMMOABGETDOFSBLOCKEDLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabgetdofsblockedlocal_ dmmoabgetdofsblockedlocal
#endif
PETSC_EXTERN void dmmoabgetdofsblockedlocal_(DM *a, PetscInt *b, const moab::EntityHandle *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMMoabGetDofsBlockedLocal(*a, *b, c, d);
  if (*ierr) return;
}
