#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspguesssetfromoptions_ KSPGUESSSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspguesssetfromoptions_ kspguesssetfromoptions
#endif
PETSC_EXTERN void kspguesssetfromoptions_(KSPGuess *a, PetscErrorCode *ierr)
{
  *ierr = KSPGuessSetFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspguesssettolerance_ KSPGUESSSETTOLERANCE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspguesssettolerance_ kspguesssettolerance
#endif
PETSC_EXTERN void kspguesssettolerance_(KSPGuess *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = KSPGuessSetTolerance(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspguessdestroy_ KSPGUESSDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspguessdestroy_ kspguessdestroy
#endif
PETSC_EXTERN void kspguessdestroy_(KSPGuess *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = KSPGuessDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspguessview_ KSPGUESSVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspguessview_ kspguessview
#endif
PETSC_EXTERN void kspguessview_(KSPGuess *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = KSPGuessView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspguesscreate_ KSPGUESSCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspguesscreate_ kspguesscreate
#endif
PETSC_EXTERN void kspguesscreate_(MPI_Fint *a, KSPGuess *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = KSPGuessCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspguesssettype_ KSPGUESSSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspguesssettype_ kspguesssettype
#endif
PETSC_EXTERN void kspguesssettype_(KSPGuess *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = KSPGuessSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspguessgettype_ KSPGUESSGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspguessgettype_ kspguessgettype
#endif
PETSC_EXTERN void kspguessgettype_(KSPGuess *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = KSPGuessGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspguessupdate_ KSPGUESSUPDATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspguessupdate_ kspguessupdate
#endif
PETSC_EXTERN void kspguessupdate_(KSPGuess *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = KSPGuessUpdate(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspguessformguess_ KSPGUESSFORMGUESS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspguessformguess_ kspguessformguess
#endif
PETSC_EXTERN void kspguessformguess_(KSPGuess *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = KSPGuessFormGuess(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspguesssetup_ KSPGUESSSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspguesssetup_ kspguesssetup
#endif
PETSC_EXTERN void kspguesssetup_(KSPGuess *a, PetscErrorCode *ierr)
{
  *ierr = KSPGuessSetUp(*a);
  if (*ierr) return;
}
