#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsseisenabled_ PETSCSSEISENABLED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsseisenabled_ petscsseisenabled
#endif
PETSC_EXTERN void petscsseisenabled_(MPI_Fint *a, PetscBool *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  CHKFORTRANNULLBOOL(c);
  *ierr = PetscSSEIsEnabled(MPI_Comm_f2c(*(a)), b, c);
  if (*ierr) return;
}
