// Populate the sidebar
//
// This is a script, and not included directly in the page, to control the total size of the book.
// The TOC contains an entry for each page, so if each page includes a copy of the TOC,
// the total size of the page becomes O(n**2).
class MDBookSidebarScrollbox extends HTMLElement {
    constructor() {
        super();
    }
    connectedCallback() {
        this.innerHTML = '<ol class="chapter"><li class="chapter-item expanded affix "><a href="introduction.html">Introduction</a></li><li class="chapter-item expanded affix "><li class="spacer"></li><li class="chapter-item expanded "><a href="examples/index.html"><strong aria-hidden="true">1.</strong> Examples</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="examples/hello-world.html"><strong aria-hidden="true">1.1.</strong> Hello, World!</a></li><li class="chapter-item expanded "><a href="examples/console-log.html"><strong aria-hidden="true">1.2.</strong> Using console.log</a></li><li class="chapter-item expanded "><a href="examples/add.html"><strong aria-hidden="true">1.3.</strong> Small Wasm files</a></li><li class="chapter-item expanded "><a href="examples/without-a-bundler.html"><strong aria-hidden="true">1.4.</strong> Without a Bundler</a></li><li class="chapter-item expanded "><a href="examples/synchronous-instantiation.html"><strong aria-hidden="true">1.5.</strong> Synchronous Instantiation</a></li><li class="chapter-item expanded "><a href="examples/import-js.html"><strong aria-hidden="true">1.6.</strong> Importing functions from JS</a></li><li class="chapter-item expanded "><a href="examples/char.html"><strong aria-hidden="true">1.7.</strong> Working with char</a></li><li class="chapter-item expanded "><a href="examples/wasm-in-wasm.html"><strong aria-hidden="true">1.8.</strong> js-sys: WebAssembly in WebAssembly</a></li><li class="chapter-item expanded "><a href="examples/dom.html"><strong aria-hidden="true">1.9.</strong> web-sys: DOM hello world</a></li><li class="chapter-item expanded "><a href="examples/closures.html"><strong aria-hidden="true">1.10.</strong> web-sys: Closures</a></li><li class="chapter-item expanded "><a href="examples/performance.html"><strong aria-hidden="true">1.11.</strong> web-sys: performance.now</a></li><li class="chapter-item expanded "><a href="examples/fetch.html"><strong aria-hidden="true">1.12.</strong> web-sys: using fetch</a></li><li class="chapter-item expanded "><a href="examples/weather_report.html"><strong aria-hidden="true">1.13.</strong> web-sys: Weather report</a></li><li class="chapter-item expanded "><a href="examples/2d-canvas.html"><strong aria-hidden="true">1.14.</strong> web-sys: canvas hello world</a></li><li class="chapter-item expanded "><a href="examples/julia.html"><strong aria-hidden="true">1.15.</strong> web-sys: canvas Julia set</a></li><li class="chapter-item expanded "><a href="examples/web-audio.html"><strong aria-hidden="true">1.16.</strong> web-sys: WebAudio</a></li><li class="chapter-item expanded "><a href="examples/webgl.html"><strong aria-hidden="true">1.17.</strong> web-sys: WebGL</a></li><li class="chapter-item expanded "><a href="examples/websockets.html"><strong aria-hidden="true">1.18.</strong> web-sys: WebSockets</a></li><li class="chapter-item expanded "><a href="examples/webrtc_datachannel.html"><strong aria-hidden="true">1.19.</strong> web-sys: WebRTC DataChannel</a></li><li class="chapter-item expanded "><a href="examples/request-animation-frame.html"><strong aria-hidden="true">1.20.</strong> web-sys: requestAnimationFrame</a></li><li class="chapter-item expanded "><a href="examples/paint.html"><strong aria-hidden="true">1.21.</strong> web-sys: A Simple Paint Program</a></li><li class="chapter-item expanded "><a href="examples/wasm-in-web-worker.html"><strong aria-hidden="true">1.22.</strong> web-sys: Wasm in Web Worker</a></li><li class="chapter-item expanded "><a href="examples/raytrace.html"><strong aria-hidden="true">1.23.</strong> Parallel Raytracing</a></li><li class="chapter-item expanded "><a href="examples/wasm-audio-worklet.html"><strong aria-hidden="true">1.24.</strong> Wasm Audio Worklet</a></li><li class="chapter-item expanded "><a href="examples/todomvc.html"><strong aria-hidden="true">1.25.</strong> web-sys: A TODO MVC App</a></li></ol></li><li class="chapter-item expanded "><a href="reference/index.html"><strong aria-hidden="true">2.</strong> Reference</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="reference/deployment.html"><strong aria-hidden="true">2.1.</strong> Deployment</a></li><li class="chapter-item expanded "><a href="reference/js-snippets.html"><strong aria-hidden="true">2.2.</strong> JS snippets</a></li><li class="chapter-item expanded "><a href="reference/static-js-objects.html"><strong aria-hidden="true">2.3.</strong> Static JS Objects</a></li><li class="chapter-item expanded "><a href="reference/passing-rust-closures-to-js.html"><strong aria-hidden="true">2.4.</strong> Passing Rust Closures to JS</a></li><li class="chapter-item expanded "><a href="reference/receiving-js-closures-in-rust.html"><strong aria-hidden="true">2.5.</strong> Receiving JS Closures in Rust</a></li><li class="chapter-item expanded "><a href="reference/js-promises-and-rust-futures.html"><strong aria-hidden="true">2.6.</strong> Promises and Futures</a></li><li class="chapter-item expanded "><a href="reference/iterating-over-js-values.html"><strong aria-hidden="true">2.7.</strong> Iterating over JS Values</a></li><li class="chapter-item expanded "><a href="reference/arbitrary-data-with-serde.html"><strong aria-hidden="true">2.8.</strong> Arbitrary Data with Serde</a></li><li class="chapter-item expanded "><a href="reference/accessing-properties-of-untyped-js-values.html"><strong aria-hidden="true">2.9.</strong> Accessing Properties of Untyped JS Values</a></li><li class="chapter-item expanded "><a href="reference/working-with-duck-typed-interfaces.html"><strong aria-hidden="true">2.10.</strong> Working with Duck-Typed Interfaces</a></li><li class="chapter-item expanded "><a href="reference/cli.html"><strong aria-hidden="true">2.11.</strong> Command Line Interface</a></li><li class="chapter-item expanded "><a href="reference/optimize-size.html"><strong aria-hidden="true">2.12.</strong> Optimizing for Size</a></li><li class="chapter-item expanded "><a href="reference/rust-targets.html"><strong aria-hidden="true">2.13.</strong> Supported Rust Targets</a></li><li class="chapter-item expanded "><a href="reference/browser-support.html"><strong aria-hidden="true">2.14.</strong> Supported Browsers</a></li><li class="chapter-item expanded "><a href="reference/weak-references.html"><strong aria-hidden="true">2.15.</strong> Support for Weak References</a></li><li class="chapter-item expanded "><a href="reference/reference-types.html"><strong aria-hidden="true">2.16.</strong> Support for Reference Types</a></li><li class="chapter-item expanded "><a href="reference/types.html"><strong aria-hidden="true">2.17.</strong> Supported Types</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="reference/types/imported-js-types.html"><strong aria-hidden="true">2.17.1.</strong> Imported JavaScript Types</a></li><li class="chapter-item expanded "><a href="reference/types/exported-rust-types.html"><strong aria-hidden="true">2.17.2.</strong> Exported Rust Types</a></li><li class="chapter-item expanded "><a href="reference/types/jsvalue.html"><strong aria-hidden="true">2.17.3.</strong> JsValue</a></li><li class="chapter-item expanded "><a href="reference/types/boxed-slices.html"><strong aria-hidden="true">2.17.4.</strong> Box&lt;[T]&gt; and Vec&lt;T&gt;</a></li><li class="chapter-item expanded "><a href="reference/types/pointers.html"><strong aria-hidden="true">2.17.5.</strong> *const T and *mut T</a></li><li class="chapter-item expanded "><a href="reference/types/non-null.html"><strong aria-hidden="true">2.17.6.</strong> NonNull&lt;T&gt;</a></li><li class="chapter-item expanded "><a href="reference/types/numbers.html"><strong aria-hidden="true">2.17.7.</strong> Numbers</a></li><li class="chapter-item expanded "><a href="reference/types/bool.html"><strong aria-hidden="true">2.17.8.</strong> bool</a></li><li class="chapter-item expanded "><a href="reference/types/char.html"><strong aria-hidden="true">2.17.9.</strong> char</a></li><li class="chapter-item expanded "><a href="reference/types/str.html"><strong aria-hidden="true">2.17.10.</strong> str</a></li><li class="chapter-item expanded "><a href="reference/types/string.html"><strong aria-hidden="true">2.17.11.</strong> String</a></li><li class="chapter-item expanded "><a href="reference/types/number-slices.html"><strong aria-hidden="true">2.17.12.</strong> Number Slices</a></li><li class="chapter-item expanded "><a href="reference/types/boxed-number-slices.html"><strong aria-hidden="true">2.17.13.</strong> Boxed Number Slices</a></li><li class="chapter-item expanded "><a href="reference/types/result.html"><strong aria-hidden="true">2.17.14.</strong> Result&lt;T, E&gt;</a></li></ol></li><li class="chapter-item expanded "><a href="reference/attributes/index.html"><strong aria-hidden="true">2.18.</strong> #[wasm_bindgen] Attributes</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="reference/attributes/on-js-imports/index.html"><strong aria-hidden="true">2.18.1.</strong> On JavaScript Imports</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="reference/attributes/on-js-imports/catch.html"><strong aria-hidden="true">2.18.1.1.</strong> catch</a></li><li class="chapter-item expanded "><a href="reference/attributes/on-js-imports/constructor.html"><strong aria-hidden="true">2.18.1.2.</strong> constructor</a></li><li class="chapter-item expanded "><a href="reference/attributes/on-js-imports/extends.html"><strong aria-hidden="true">2.18.1.3.</strong> extends</a></li><li class="chapter-item expanded "><a href="reference/attributes/on-js-imports/getter-and-setter.html"><strong aria-hidden="true">2.18.1.4.</strong> getter and setter</a></li><li class="chapter-item expanded "><a href="reference/attributes/on-js-imports/final.html"><strong aria-hidden="true">2.18.1.5.</strong> final</a></li><li class="chapter-item expanded "><a href="reference/attributes/on-js-imports/indexing-getter-setter-deleter.html"><strong aria-hidden="true">2.18.1.6.</strong> indexing_getter, indexing_setter, and indexing_deleter</a></li><li class="chapter-item expanded "><a href="reference/attributes/on-js-imports/js_class.html"><strong aria-hidden="true">2.18.1.7.</strong> js_class = "Blah"</a></li><li class="chapter-item expanded "><a href="reference/attributes/on-js-imports/js_name.html"><strong aria-hidden="true">2.18.1.8.</strong> js_name</a></li><li class="chapter-item expanded "><a href="reference/attributes/on-js-imports/js_namespace.html"><strong aria-hidden="true">2.18.1.9.</strong> js_namespace</a></li><li class="chapter-item expanded "><a href="reference/attributes/on-js-imports/method.html"><strong aria-hidden="true">2.18.1.10.</strong> method</a></li><li class="chapter-item expanded "><a href="reference/attributes/on-js-imports/module.html"><strong aria-hidden="true">2.18.1.11.</strong> module = "blah"</a></li><li class="chapter-item expanded "><a href="reference/attributes/on-js-imports/raw_module.html"><strong aria-hidden="true">2.18.1.12.</strong> raw_module = "blah"</a></li><li class="chapter-item expanded "><a href="reference/attributes/on-js-imports/no_deref.html"><strong aria-hidden="true">2.18.1.13.</strong> no_deref</a></li><li class="chapter-item expanded "><a href="reference/attributes/on-js-imports/static_method_of.html"><strong aria-hidden="true">2.18.1.14.</strong> static_method_of = Blah</a></li><li class="chapter-item expanded "><a href="reference/attributes/on-js-imports/structural.html"><strong aria-hidden="true">2.18.1.15.</strong> structural</a></li><li class="chapter-item expanded "><a href="reference/attributes/on-js-imports/typescript_type.html"><strong aria-hidden="true">2.18.1.16.</strong> typescript_type</a></li><li class="chapter-item expanded "><a href="reference/attributes/on-js-imports/variadic.html"><strong aria-hidden="true">2.18.1.17.</strong> variadic</a></li><li class="chapter-item expanded "><a href="reference/attributes/on-js-imports/vendor_prefix.html"><strong aria-hidden="true">2.18.1.18.</strong> vendor_prefix</a></li></ol></li><li class="chapter-item expanded "><a href="reference/attributes/on-rust-exports/index.html"><strong aria-hidden="true">2.18.2.</strong> On Rust Exports</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="reference/attributes/on-rust-exports/constructor.html"><strong aria-hidden="true">2.18.2.1.</strong> constructor</a></li><li class="chapter-item expanded "><a href="reference/attributes/on-rust-exports/js_name.html"><strong aria-hidden="true">2.18.2.2.</strong> js_name = Blah</a></li><li class="chapter-item expanded "><a href="reference/attributes/on-rust-exports/js_class.html"><strong aria-hidden="true">2.18.2.3.</strong> js_class = Blah</a></li><li class="chapter-item expanded "><a href="reference/attributes/on-rust-exports/readonly.html"><strong aria-hidden="true">2.18.2.4.</strong> readonly</a></li><li class="chapter-item expanded "><a href="reference/attributes/on-rust-exports/skip.html"><strong aria-hidden="true">2.18.2.5.</strong> skip</a></li><li class="chapter-item expanded "><a href="reference/attributes/on-rust-exports/skip_jsdoc.html"><strong aria-hidden="true">2.18.2.6.</strong> skip_jsdoc</a></li><li class="chapter-item expanded "><a href="reference/attributes/on-rust-exports/start.html"><strong aria-hidden="true">2.18.2.7.</strong> start</a></li><li class="chapter-item expanded "><a href="reference/attributes/on-rust-exports/main.html"><strong aria-hidden="true">2.18.2.8.</strong> main</a></li><li class="chapter-item expanded "><a href="reference/attributes/on-rust-exports/typescript_custom_section.html"><strong aria-hidden="true">2.18.2.9.</strong> typescript_custom_section</a></li><li class="chapter-item expanded "><a href="reference/attributes/on-rust-exports/getter-and-setter.html"><strong aria-hidden="true">2.18.2.10.</strong> getter and setter</a></li><li class="chapter-item expanded "><a href="reference/attributes/on-rust-exports/inspectable.html"><strong aria-hidden="true">2.18.2.11.</strong> inspectable</a></li><li class="chapter-item expanded "><a href="reference/attributes/on-rust-exports/skip_typescript.html"><strong aria-hidden="true">2.18.2.12.</strong> skip_typescript</a></li><li class="chapter-item expanded "><a href="reference/attributes/on-rust-exports/getter_with_clone.html"><strong aria-hidden="true">2.18.2.13.</strong> getter_with_clone</a></li><li class="chapter-item expanded "><a href="reference/attributes/on-rust-exports/unchecked_type.html"><strong aria-hidden="true">2.18.2.14.</strong> unchecked_return_type and unchecked_param_type</a></li><li class="chapter-item expanded "><a href="reference/attributes/on-rust-exports/description.html"><strong aria-hidden="true">2.18.2.15.</strong> return_description and param_description</a></li></ol></li></ol></li></ol></li><li class="chapter-item expanded "><a href="web-sys/index.html"><strong aria-hidden="true">3.</strong> web-sys</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="web-sys/using-web-sys.html"><strong aria-hidden="true">3.1.</strong> Using web-sys</a></li><li class="chapter-item expanded "><a href="web-sys/cargo-features.html"><strong aria-hidden="true">3.2.</strong> Cargo Features</a></li><li class="chapter-item expanded "><a href="web-sys/function-overloads.html"><strong aria-hidden="true">3.3.</strong> Function Overloads</a></li><li class="chapter-item expanded "><a href="web-sys/type-translations.html"><strong aria-hidden="true">3.4.</strong> Type Translations</a></li><li class="chapter-item expanded "><a href="web-sys/inheritance.html"><strong aria-hidden="true">3.5.</strong> Inheritance</a></li><li class="chapter-item expanded "><a href="web-sys/unstable-apis.html"><strong aria-hidden="true">3.6.</strong> Unstable APIs</a></li></ol></li><li class="chapter-item expanded "><a href="wasm-bindgen-test/index.html"><strong aria-hidden="true">4.</strong> Testing with wasm-bindgen-test</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="wasm-bindgen-test/usage.html"><strong aria-hidden="true">4.1.</strong> Usage</a></li><li class="chapter-item expanded "><a href="wasm-bindgen-test/asynchronous-tests.html"><strong aria-hidden="true">4.2.</strong> Writing Asynchronous Tests</a></li><li class="chapter-item expanded "><a href="wasm-bindgen-test/browsers.html"><strong aria-hidden="true">4.3.</strong> Testing in Headless Browsers</a></li><li class="chapter-item expanded "><a href="wasm-bindgen-test/continuous-integration.html"><strong aria-hidden="true">4.4.</strong> Continuous Integration</a></li><li class="chapter-item expanded "><a href="wasm-bindgen-test/coverage.html"><strong aria-hidden="true">4.5.</strong> Coverage (Experimental)</a></li></ol></li><li class="chapter-item expanded "><a href="contributing/index.html"><strong aria-hidden="true">5.</strong> Contributing to wasm-bindgen</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="contributing/testing.html"><strong aria-hidden="true">5.1.</strong> Testing</a></li><li class="chapter-item expanded "><a href="contributing/design/index.html"><strong aria-hidden="true">5.2.</strong> Internal Design</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="contributing/design/js-objects-in-rust.html"><strong aria-hidden="true">5.2.1.</strong> JS Objects in Rust</a></li><li class="chapter-item expanded "><a href="contributing/design/exporting-rust.html"><strong aria-hidden="true">5.2.2.</strong> Exporting a function to JS</a></li><li class="chapter-item expanded "><a href="contributing/design/exporting-rust-struct.html"><strong aria-hidden="true">5.2.3.</strong> Exporting a struct to JS</a></li><li class="chapter-item expanded "><a href="contributing/design/importing-js.html"><strong aria-hidden="true">5.2.4.</strong> Importing a function from JS</a></li><li class="chapter-item expanded "><a href="contributing/design/importing-js-struct.html"><strong aria-hidden="true">5.2.5.</strong> Importing a class from JS</a></li><li class="chapter-item expanded "><a href="contributing/design/rust-type-conversions.html"><strong aria-hidden="true">5.2.6.</strong> Rust Type conversions</a></li><li class="chapter-item expanded "><a href="contributing/design/describe.html"><strong aria-hidden="true">5.2.7.</strong> Types in wasm-bindgen</a></li></ol></li><li class="chapter-item expanded "><a href="contributing/js-sys/index.html"><strong aria-hidden="true">5.3.</strong> js-sys</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="contributing/js-sys/testing.html"><strong aria-hidden="true">5.3.1.</strong> Testing</a></li><li class="chapter-item expanded "><a href="contributing/js-sys/adding-more-apis.html"><strong aria-hidden="true">5.3.2.</strong> Adding More APIs</a></li></ol></li><li class="chapter-item expanded "><a href="contributing/web-sys/index.html"><strong aria-hidden="true">5.4.</strong> web-sys</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="contributing/web-sys/overview.html"><strong aria-hidden="true">5.4.1.</strong> Overview</a></li><li class="chapter-item expanded "><a href="contributing/web-sys/testing.html"><strong aria-hidden="true">5.4.2.</strong> Testing</a></li><li class="chapter-item expanded "><a href="contributing/web-sys/logging.html"><strong aria-hidden="true">5.4.3.</strong> Logging</a></li><li class="chapter-item expanded "><a href="contributing/web-sys/supporting-more-web-apis.html"><strong aria-hidden="true">5.4.4.</strong> Supporting More Web APIs</a></li></ol></li><li class="chapter-item expanded "><a href="contributing/publishing.html"><strong aria-hidden="true">5.5.</strong> Publishing</a></li><li class="chapter-item expanded "><a href="contributing/team.html"><strong aria-hidden="true">5.6.</strong> Team</a></li></ol></li></ol>';
        // Set the current, active page, and reveal it if it's hidden
        let current_page = document.location.href.toString().split("#")[0];
        if (current_page.endsWith("/")) {
            current_page += "index.html";
        }
        var links = Array.prototype.slice.call(this.querySelectorAll("a"));
        var l = links.length;
        for (var i = 0; i < l; ++i) {
            var link = links[i];
            var href = link.getAttribute("href");
            if (href && !href.startsWith("#") && !/^(?:[a-z+]+:)?\/\//.test(href)) {
                link.href = path_to_root + href;
            }
            // The "index" page is supposed to alias the first chapter in the book.
            if (link.href === current_page || (i === 0 && path_to_root === "" && current_page.endsWith("/index.html"))) {
                link.classList.add("active");
                var parent = link.parentElement;
                if (parent && parent.classList.contains("chapter-item")) {
                    parent.classList.add("expanded");
                }
                while (parent) {
                    if (parent.tagName === "LI" && parent.previousElementSibling) {
                        if (parent.previousElementSibling.classList.contains("chapter-item")) {
                            parent.previousElementSibling.classList.add("expanded");
                        }
                    }
                    parent = parent.parentElement;
                }
            }
        }
        // Track and set sidebar scroll position
        this.addEventListener('click', function(e) {
            if (e.target.tagName === 'A') {
                sessionStorage.setItem('sidebar-scroll', this.scrollTop);
            }
        }, { passive: true });
        var sidebarScrollTop = sessionStorage.getItem('sidebar-scroll');
        sessionStorage.removeItem('sidebar-scroll');
        if (sidebarScrollTop) {
            // preserve sidebar scroll position when navigating via links within sidebar
            this.scrollTop = sidebarScrollTop;
        } else {
            // scroll sidebar to current active section when navigating via "next/previous chapter" buttons
            var activeSection = document.querySelector('#sidebar .active');
            if (activeSection) {
                activeSection.scrollIntoView({ block: 'center' });
            }
        }
        // Toggle buttons
        var sidebarAnchorToggles = document.querySelectorAll('#sidebar a.toggle');
        function toggleSection(ev) {
            ev.currentTarget.parentElement.classList.toggle('expanded');
        }
        Array.from(sidebarAnchorToggles).forEach(function (el) {
            el.addEventListener('click', toggleSection);
        });
    }
}
window.customElements.define("mdbook-sidebar-scrollbox", MDBookSidebarScrollbox);
