char lighting_vert[] = "#pragma requires(LIGHTING)\n"
                       "\n"
                       "void directionalLight( int lightNum, vec3 normal, inout vec4 color )\n"
                       "{\n"
                       "    vec3 n = normalize(gl_NormalMatrix * normal);\n"
                       "\n"
                       "    float NdotL = dot( n, normalize(gl_LightSource[lightNum].position.xyz) );\n"
                       "    NdotL = max( 0.0, NdotL );\n"
                       "\n"
                       "    float NdotHV = dot( n, gl_LightSource[lightNum].halfVector.xyz );\n"
                       "    NdotHV = max( 0.0, NdotHV );\n"
                       "#if 1\n"
                       "    color *= gl_LightSource[lightNum].ambient +\n"
                       "             gl_LightSource[lightNum].diffuse * NdotL;\n"
                       "#else\n"
                       "    color *= gl_FrontLightModelProduct.sceneColor +\n"
                       "             gl_FrontLightProduct[lightNum].ambient +\n"
                       "             gl_FrontLightProduct[lightNum].diffuse * NdotL;\n"
                       "#endif\n"
                       "#if 0\n"
                       "    if ( NdotL * NdotHV > 0.0 )\n"
                       "        color += gl_FrontLightProduct[lightNum].specular * pow( NdotHV, gl_FrontMaterial.shininess );\n"
                       "#endif\n"
                       "}\n"
                       "\n";
