/* <!-- copyright */
/*
 * aria2 - The high speed download utility
 *
 * Copyright (C) 2012 Tatsuhiro Tsujikawa
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */
/* copyright --> */
#ifndef D_STRUCT_PARSER_STATE_MACHINE_H
#define D_STRUCT_PARSER_STATE_MACHINE_H

#include "common.h"

namespace aria2 {

enum StructElementType {
  STRUCT_DICT_T,
  STRUCT_DICT_KEY_T,
  STRUCT_DICT_DATA_T,
  STRUCT_ARRAY_T,
  STRUCT_ARRAY_DATA_T,
  STRUCT_STRING_T,
  STRUCT_NUMBER_T,
  STRUCT_BOOL_T,
  STRUCT_NULL_T
};

// Interface for streaming parser of structured data format (e.g.,
// JSON, Bencode).
class StructParserStateMachine {
public:
  virtual ~StructParserStateMachine() = default;

  virtual void beginElement(int elementType) = 0;
  virtual void endElement(int elementType) = 0;
  virtual void reset() = 0;
  virtual void charactersCallback(const char* data, size_t len) = 0;
  virtual void numberCallback(int64_t number, int frac, int exp) = 0;
  virtual void boolCallback(bool bval) = 0;
};

} //  namespace aria2

#endif // D_STRUCT_PARSER_STATE_MACHINE_H
