from _typeshed import Incomplete
from collections.abc import Mapping
from typing import Any
from typing_extensions import Self

NoneType: type[None]

class LongStr(str):
    lazy: bool

LongUnicode = LongStr

class SetType:
    def __deepcopy__(self, memo) -> Self: ...
    item_type: Incomplete
    def __init__(self, item_type) -> None: ...
    def __eq__(self, other): ...
    def __ne__(self, other): ...
    def __hash__(self) -> int: ...

class FuncType:
    def __deepcopy__(self, memo) -> Self: ...
    func: Incomplete
    def __init__(self, func) -> None: ...
    def __eq__(self, other): ...
    def __ne__(self, other): ...
    def __hash__(self) -> int: ...

class MethodType:
    def __deepcopy__(self, memo) -> Self: ...
    obj: Incomplete
    func: Incomplete
    def __init__(self, method) -> None: ...
    def __eq__(self, other): ...
    def __ne__(self, other): ...
    def __hash__(self) -> int: ...

raw_sql_cache: dict[str, Incomplete]

def parse_raw_sql(sql: str): ...
def raw_sql(sql: str, result_type=None) -> RawSQL: ...

class RawSQL:
    def __deepcopy__(self, memo) -> None: ...
    sql: str
    result_type: Incomplete
    def __init__(
        self, sql: str, globals: dict[str, Any] | None = None, locals: Mapping[str, object] | None = None, result_type=None
    ) -> None: ...

class RawSQLType:
    def __deepcopy__(self, memo) -> Self: ...
    sql: str
    items: Incomplete
    types: Incomplete
    result_type: Incomplete
    def __init__(self, sql: str, items, types, result_type) -> None: ...
    def __hash__(self) -> int: ...
    def __eq__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...

class QueryType:
    query_key: Incomplete
    translator: Incomplete
    limit: Incomplete
    offset: Incomplete
    def __init__(self, query, limit=None, offset=None) -> None: ...
    def __hash__(self) -> int: ...
    def __eq__(self, other): ...
    def __ne__(self, other): ...

def normalize(value): ...
def normalize_type(t): ...

coercions: Incomplete

def coerce_types(t1, t2): ...
def are_comparable_types(t1, t2, op: str = "=="): ...

class TrackedValue:
    obj_ref: Incomplete
    attr: Incomplete
    def __init__(self, obj, attr) -> None: ...
    @classmethod
    def make(cls, obj, attr, value): ...
    def get_untracked(self) -> None: ...

def tracked_method(func): ...

class TrackedDict(TrackedValue, dict[Incomplete, Incomplete]):
    def __init__(self, obj, attr, value) -> None: ...
    def __reduce__(self): ...
    __setitem__: Incomplete
    __delitem__: Incomplete
    def update(self, *args, **kwargs): ...
    setdefault: Incomplete
    pop: Incomplete
    popitem: Incomplete
    clear: Incomplete
    def get_untracked(self): ...

class TrackedList(TrackedValue, list[Incomplete]):
    def __init__(self, obj, attr, value) -> None: ...
    def __reduce__(self): ...
    __setitem__: Incomplete
    __delitem__: Incomplete
    extend: Incomplete
    append: Incomplete
    pop: Incomplete
    remove: Incomplete
    insert: Incomplete
    reverse: Incomplete
    sort: Incomplete
    clear: Incomplete
    def get_untracked(self): ...

def validate_item(item_type, item): ...

class TrackedArray(TrackedList):
    item_type: Incomplete
    def __init__(self, obj, attr, value) -> None: ...
    def extend(self, items) -> None: ...
    def append(self, item) -> None: ...
    def insert(self, index, item) -> None: ...
    def __setitem__(self, index, item) -> None: ...
    def __contains__(self, item) -> bool: ...

class Json:
    @classmethod
    def default_empty_value(cls): ...
    wrapped: Incomplete
    def __init__(self, wrapped) -> None: ...

class Array:
    item_type: type | None
    @classmethod
    def default_empty_value(cls): ...

class IntArray(Array):
    item_type: type[int]

class StrArray(Array):
    item_type: type[str]

class FloatArray(Array):
    item_type: type[float]

numeric_types: set[type]
comparable_types: set[type]
primitive_types: set[type]
function_types: set[type]
type_normalization_dict: dict[type, type]
array_types: dict[type, type[Array]]
