import datetime
from _typeshed import ConvertibleToInt
from typing import Final, SupportsIndex, overload

__version__: Final[str]
__all__ = ["LunarDate"]

class LunarDate:
    year: int
    month: int
    day: int
    isLeapMonth: bool
    def __init__(self, year: int, month: int, day: int, isLeapMonth: bool | None = False) -> None: ...
    @staticmethod
    def leapMonthForYear(year: int) -> int | None: ...
    @staticmethod
    def fromSolarDate(year: SupportsIndex, month: SupportsIndex, day: SupportsIndex) -> LunarDate: ...
    def toSolarDate(self) -> datetime.date: ...
    @overload
    def __sub__(self, other: LunarDate | datetime.date) -> datetime.timedelta: ...
    @overload
    def __sub__(self, other: datetime.timedelta) -> LunarDate: ...
    def __rsub__(self, other: datetime.date) -> datetime.timedelta: ...
    def __add__(self, other: datetime.timedelta) -> LunarDate: ...
    def __radd__(self, other: datetime.timedelta) -> LunarDate: ...
    def __eq__(self, other: object) -> bool: ...
    def __lt__(self, other: LunarDate | datetime.date) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __ge__(self, other: LunarDate | datetime.date) -> bool: ...
    @classmethod
    def today(cls) -> LunarDate: ...

yearInfos: Final[list[int]]

def yearInfo2yearDay(yearInfo: ConvertibleToInt) -> int: ...

yearDays: Final[list[int]]

def day2LunarDate(offset: ConvertibleToInt) -> None: ...
