# SPDX-FileCopyrightText: 2022-2023 Blender Authors
#
# SPDX-License-Identifier: GPL-2.0-or-later

set(VULKAN_MEMORY_ALLOCATOR_EXTRA_ARGS
  -DVMA_BUILD_DOCUMENTATION=OFF
  -DVMA_BUILD_SAMPLES=OFF
  -DVMA_ENABLE_INSTALL=ON
)

ExternalProject_Add(external_vulkan_memory_allocator
  URL file://${PACKAGE_DIR}/${VULKAN_MEMORY_ALLOCATOR_FILE}
  DOWNLOAD_DIR ${DOWNLOAD_DIR}
  URL_HASH ${VULKAN_MEMORY_ALLOCATOR_HASH_TYPE}=${VULKAN_MEMORY_ALLOCATOR_HASH}
  PREFIX ${BUILD_DIR}/vulkan_memory_allocator
  CMAKE_GENERATOR ${PLATFORM_ALT_GENERATOR}

  CMAKE_ARGS
    -DCMAKE_INSTALL_PREFIX=${LIBDIR}/vulkan_memory_allocator
    ${DEFAULT_CMAKE_FLAGS}
    ${VULKAN_MEMORY_ALLOCATOR_EXTRA_ARGS}

  INSTALL_DIR ${LIBDIR}/vulkan_memory_allocator
)
