//! Bindings generated by `minwin` 0.1.0
#![allow(
    non_snake_case,
    non_upper_case_globals,
    non_camel_case_types,
    clippy::upper_case_acronyms,
    unsafe_code
)]
#[link(name = "ntdll", kind = "raw-dylib")]
unsafe extern "system" {
    #[link_name = "NtClose"]
    pub fn nt_close(handle: Handle) -> Ntstatus;
    #[link_name = "NtOpenProcess"]
    pub fn nt_open_process(
        process_handle: *mut Handle,
        desired_access: u32,
        object_attributes: *const ObjectAttributes,
        client_id: *const ClientId,
    ) -> Ntstatus;
    #[link_name = "NtQueryInformationProcess"]
    pub fn nt_query_information_process(
        process_handle: Handle,
        process_information_class: Processinfoclass::Enum,
        process_information: *mut ::core::ffi::c_void,
        process_information_length: u32,
        return_length: *mut u32,
    ) -> Ntstatus;
}
pub const MaxPath: u32 = 260;
#[repr(C)]
pub struct ClientId {
    pub unique_process: Handle,
    pub unique_thread: Handle,
}
pub type Handle = isize;
#[repr(C)]
pub struct ListEntry {
    pub flink: *mut ListEntry,
    pub blink: *mut ListEntry,
}
pub type Ntstatus = i32;
pub const StatusSuccess: Ntstatus = 0;
#[repr(C)]
pub struct ObjectAttributes {
    pub length: u32,
    pub root_directory: Handle,
    pub object_name: *mut UnicodeString,
    pub attributes: u32,
    pub security_descriptor: *mut ::core::ffi::c_void,
    pub security_quality_of_service: *mut ::core::ffi::c_void,
}
#[repr(C)]
pub struct Peb {
    pub reserved1: [u8; 2],
    pub being_debugged: u8,
    pub reserved2: [u8; 1],
    pub reserved3: [*mut ::core::ffi::c_void; 2],
    pub ldr: *mut PebLdrData,
    pub process_parameters: *mut RtlUserProcessParameters,
    pub reserved4: [*mut ::core::ffi::c_void; 3],
    pub atl_thunk_s_list_ptr: *mut ::core::ffi::c_void,
    pub reserved5: *mut ::core::ffi::c_void,
    pub reserved6: u32,
    pub reserved7: *mut ::core::ffi::c_void,
    pub reserved8: u32,
    pub atl_thunk_s_list_ptr32: u32,
    pub reserved9: [*mut ::core::ffi::c_void; 45],
    pub reserved10: [u8; 96],
    pub post_process_init_routine: PpsPostProcessInitRoutine,
    pub reserved11: [u8; 128],
    pub reserved12: [*mut ::core::ffi::c_void; 1],
    pub session_id: u32,
}
#[repr(C)]
pub struct PebLdrData {
    pub reserved1: [u8; 8],
    pub reserved2: [*mut ::core::ffi::c_void; 3],
    pub in_memory_order_module_list: ListEntry,
}
pub type PpsPostProcessInitRoutine = ::core::option::Option<unsafe extern "system" fn()>;
pub mod ProcessAccessRights {
    pub type Enum = u32;
    pub const ProcessQueryInformation: Enum = 1024;
}
#[repr(C)]
pub struct ProcessBasicInformation {
    pub exit_status: Ntstatus,
    pub peb_base_address: *mut Peb,
    pub affinity_mask: usize,
    pub base_priority: i32,
    pub unique_process_id: usize,
    pub inherited_from_unique_process_id: usize,
}
pub mod Processinfoclass {
    pub type Enum = i32;
    pub const ProcessBasicInformation: Enum = 0;
    pub const ProcessImageFileName: Enum = 27;
}
pub type Pwstr = *mut u16;
#[repr(C)]
pub struct RtlUserProcessParameters {
    pub reserved1: [u8; 16],
    pub reserved2: [*mut ::core::ffi::c_void; 10],
    pub image_path_name: UnicodeString,
    pub command_line: UnicodeString,
}
#[repr(C)]
pub struct UnicodeString {
    pub length: u16,
    pub maximum_length: u16,
    pub buffer: Pwstr,
}
