# 0.75.2 release notes

**Release date:** 2020-10-26

## Summary

This is a maintenance release from the 0.75.x stable branch.


## How to upgrade

<div class="compact" markdown>

Download and launch the latest version:

- [Linux](../linux.md) (or [Steam on Linux](../linux.md#steam))
- [Windows](../windows.md)
- [macOS](../macos.md)

</div>

At the`Z:\>` prompt, run `config -wc` to write the new configuration file. Any
existing settings will be retained, however, extraneous comments will be
dropped.


## New features in detail

### Select monochrome palette colour

When emulating monochrome displays (via `machine = hercules` or
`machine = cga_mono`), the default colour palette can now be set to either
`white`, `paperwhite`, `green`, or `amber` in the configuration file, as
follows:

``` ini
[render]
monochrome_palette = amber
```

See: #607


### Raw mouse input

You can enable this option to bypass the operating system's mouse
acceleration and sensitivity settings. This works in
fullscreen or when the mouse is captured in windowed mode.

The option can be set in the `[sdl]` section of the configuration file:

``` ini
[sdl]
raw_mouse_input = true
```

The feature is disabled by default, but some games (e.g. FPS titles, like
**DOOM** or **Dark Forces**) work better with raw input enabled
(especially when used with modern, very sensitive gaming mice).

See: #636


## Bugfixes

- Bundle C++ runtime libraries with Windows builds for users
  on Windows 7, 8.x, and those who disabled Windows 10 update mechanism.
  (#675)

- Reimplement CLS command to prevent text mode reset. (#639)

- Fix whitespace handling in modem ATD command. (#652)

- Fix boot failure when using HDD image. (#522)


## Notes for packagers

This release includes numerous fixes affecting our build system and other
changes relevant for packaging (contributed by Gentoo packagers, and people
preparing Debian, Fedora, and Flatpak packages)---prompt upgrade is recommended.

If you're packaging DOSBox Staging for your OS, we have a few tips:

- We strongly suggest keeping our default binary name: `dosbox`.
  DOSBox&nbsp;Staging is a drop-in replacement for older DOSBox versions---some
  existing and popular programs, such as Wine and GUI frontends, depend on the
  `dosbox` binary name.  It's also the default name of our man page and
  appears in the documentation.

- You don't need to generate your own desktop entry, appstream metadata
  (`metainfo.xml`), nor package description: please see the relevant files
  in the `contrib/linux/` directory.

- We provide desktop icons in scalable or raster formats (optimized for small
  sizes). Find them in the `contrib/icons/` directory.

- During the configuration step, remember to add
  [`-DNDEBUG`](https://en.cppreference.com/w/c/error/assert)
  to preprocessor flags (it's important!), as well as using `-O3` in both
  C and C++ compiler flags, for example:

    ```
    ./configure CPPFLAGS="-DNDEBUG" CFLAGS="-O3" CXXFLAGS="-O3"
    ```

- Our testing indicates that GCC generates faster binaries than Clang, but
  use whatever compiler is more appropriate for your OS.

- The license is "GNU GPL version 2.0 *or later*" (SPDX: `GPL-2.0-or-later`).
  GitHub does not show "or later", but our packages should show the proper
  license info.

To all our package maintainers: thank you! :smile:


## Contributors

### Maintainers

<div class="compact" markdown>

- Patryk Obara
- kcgen
- nemo93

</div>

### Contributors

<div class="compact" markdown>

- Bernard Cafarelli
- David Heidelberg
- Feignint
- MasterO2
- NicknineTheEagle
- WengierWu

</div>


## Thank you

We are extremely grateful for all contributions, including the invaluable improvements merged in from the DOSBox project.

