<!-- SPDX-License-Identifier: BSD-3-Clause -->
<!-- Copyright (c) Contributors to the OpenEXR Project -->

[![License](https://img.shields.io/github/license/AcademySoftwareFoundation/Imath)](LICENSE.md)
[![CII Best Practices](https://bestpractices.coreinfrastructure.org/projects/2799/badge)](https://bestpractices.coreinfrastructure.org/projects/2799)
[![OpenSSF Scorecard](https://api.securityscorecards.dev/projects/github.com/AcademySoftwareFoundation/Imath/badge)](https://securityscorecards.dev/viewer/?uri=github.com/AcademySoftwareFoundation/Imath)
[![Build Status](https://github.com/AcademySoftwareFoundation/Imath/workflows/CI/badge.svg)](https://github.com/AcademySoftwareFoundation/Imath/actions?query=workflow%3ACI)
[![Analysis Status](https://github.com/AcademySoftwareFoundation/Imath/workflows/Analysis/badge.svg)](https://github.com/AcademySoftwareFoundation/Imath/actions?query=workflow%3AAnalysis)
[![Quality Gate Status](https://sonarcloud.io/api/project_badges/measure?project=AcademySoftwareFoundation_Imath&metric=alert_status)](https://sonarcloud.io/dashboard?id=AcademySoftwareFoundation_Imath)

# Imath

Imath is a basic, light-weight, and efficient C++ representation of 2D
and 3D vectors and matrices and other simple but useful mathematical
objects, functions, and data types common in computer graphics
applications, including the “half” 16-bit floating-point type.

Imath also includes optional python bindings for all types and
functions, including optimized implementations of vector and matrix
arrays.

## Project Mission

The goals of the Imath project are simplicity, ease of use,
correctness and verifiability, performance, and breadth of
adoption. Imath is not intended to be a comprehensive linear algebra
or numerical analysis package.

## Project Governance

OpenEXR is a project of the [Academy Software
Foundation](https://www.aswf.io). See the project's [governance
policies](GOVERNANCE.md), [contribution guidelines](CONTRIBzuTING.md), and [code of conduct](CODE_OF_CONDUCT)
for more information.

The OpenEXR project is dedicated to promoting a harassment-free
community. Read our [code of conduct](CODE_OF_CONDUCT.md).

## Supported Platforms

Imath builds on Linux, macOS, Microsoft Windows, and is
cross-compilable on other systems.

## A Note about Versioning

Because Imath was originally distributed as a part of OpenEXR, it has
already had two major release versions, as a part of OpenEXR v1 and
v2. To avoid confusion with these original releases, the first
version of Imath released independently of OpenEXR is Version v3.0. To
be clear, the versioning and release of Imath is no longer tied to
OpenEXR.

# Quick Start

Technical documentation for the Imath classes and functions can be found at
https://imath.readthedocs.io.

See the [Install](https://imath.readthedocs.io) instructions for
how to download, install, or build Imath from source.

If you encounter problems compiling code or building projects written
with an earlier release of Imath, the [porting
guide](https://openexr.readthedocs.io/en/latest/PortingGuide.html)
explains some of the differences and how to address them.

# Community

* **Ask a question:**

  - Email: openexr-dev@lists.aswf.io

  - Slack: [academysoftwarefdn#openexr](https://academysoftwarefdn.slack.com/archives/CMLRW4N73)

* **Attend a meeting:**

  - Technical Steering Committee meetings are open to the
    public, fortnightly on Thursdays, 1:30pm Pacific Time.

  - Calendar: https://lists.aswf.io/g/openexr-dev/calendar

* **Report a bug:**

  - Submit an Issue: https://github.com/AcademySoftwareFoundation/Imath/issues

* **Report a security vulnerability:**

  - Email to security@openexr.com

* **Contribute a Fix, Feature, or Improvement:**

  - Read the [Contribution Guidelines](CONTRIBUTING.md) and [Code of Conduct](CODE_OF_CONDUCT.md)

  - Sign the [Contributor License
    Agreement](https://contributor.easycla.lfx.linuxfoundation.org/#/cla/project/2e8710cb-e379-4116-a9ba-964f83618cc5/user/564e571e-12d7-4857-abd4-898939accdd7)
  
  - Submit a Pull Request: https://github.com/AcademySoftwareFoundation/Imath/pulls

# Resources

- Technical documentation: https://imath.readthedocs.io
- Porting help: [OpenEXR/Imath Version 2.x to 3.x Porting Guide](https://openexr.readthedocs.io/en/latest/PortingGuide.html)
- Security policy: [SECURITY.md](SECURITY.md)
- Release notes: [CHANGES.md](CHANGES.md)
- Contributors: [CONTRIBUTORS.md](CONTRIBUTORS.md)  

# License

Imath is released under OpenEXR's [BSD-3-Clause](LICENSE.md) license.

---

![aswf](https://github.com/AcademySoftwareFoundation/openexr/blob/main/ASWF/images/aswf.png)
